/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.intgr.nonprobabilistic;

import com.google.common.collect.Iterables;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.vertices.LoadShape;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.ProxyVertex;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.VertexLabel;
import io.improbable.keanu.vertices.intgr.IntegerVertex;

public class IntegerProxyVertex
extends IntegerVertex
implements ProxyVertex<IntegerVertex>,
NonProbabilistic<IntegerTensor> {
    private static final String LABEL_NAME = "label";
    private static final String PARENT_NAME = "parent";

    public IntegerProxyVertex(VertexLabel label) {
        this(Tensor.SCALAR_SHAPE, label);
    }

    @ExportVertexToPythonBindings
    public IntegerProxyVertex(long[] shape, VertexLabel label) {
        super(shape);
        this.setLabel(label);
    }

    public IntegerProxyVertex(@LoadShape long[] shape, @LoadVertexParam(value="label") String labelString, @LoadVertexParam(value="parent", isNullable=true) IntegerVertex parent) {
        super(shape);
        VertexLabel vertexLabel = VertexLabel.parseLabel(labelString);
        this.setLabel(vertexLabel);
        if (parent != null) {
            this.setParent(parent);
        }
    }

    @Override
    public <V extends Vertex<IntegerTensor>> V setLabel(VertexLabel label) {
        if (this.getLabel() != null && !this.getLabel().getUnqualifiedName().equals(label.getUnqualifiedName())) {
            throw new RuntimeException("You should not change the label on a Proxy Vertex");
        }
        return super.setLabel(label);
    }

    public IntegerProxyVertex(long[] tensorShape, String label) {
        this(tensorShape, new VertexLabel(label));
    }

    @Override
    public IntegerTensor calculate() {
        return (IntegerTensor)this.getParent().getValue();
    }

    @Override
    public void setParent(IntegerVertex newParent) {
        TensorShapeValidation.checkTensorsMatchNonLengthOneShapeOrAreLengthOne(this.getShape(), new long[][]{newParent.getShape()});
        this.setParents(newParent);
    }

    @SaveVertexParam(value="parent", isNullable=true)
    public IntegerVertex getParent() {
        return (IntegerVertex)Iterables.getOnlyElement(this.getParents(), null);
    }

    @Override
    public boolean hasParent() {
        return !this.getParents().isEmpty();
    }

    @SaveVertexParam(value="label")
    public String getLabelParameter() {
        return this.getLabel().toString();
    }
}

