/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.intgr.nonprobabilistic;

import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.bool.BooleanVertex;
import io.improbable.keanu.vertices.intgr.IntegerVertex;

public class IntegerIfVertex
extends IntegerVertex
implements NonProbabilistic<IntegerTensor> {
    protected static final String PREDICATE_NAME = "predicate";
    protected static final String THEN_NAME = "then";
    protected static final String ELSE_NAME = "else";
    private final BooleanVertex predicate;
    private final IntegerVertex thn;
    private final IntegerVertex els;

    @ExportVertexToPythonBindings
    public IntegerIfVertex(@LoadVertexParam(value="predicate") BooleanVertex predicate, @LoadVertexParam(value="then") IntegerVertex thn, @LoadVertexParam(value="else") IntegerVertex els) {
        super(TensorShapeValidation.checkTernaryConditionShapeIsValid(predicate.getShape(), thn.getShape(), els.getShape()));
        this.predicate = predicate;
        this.thn = thn;
        this.els = els;
        this.setParents(predicate, thn, els);
    }

    @SaveVertexParam(value="predicate")
    public BooleanVertex getPredicate() {
        return this.predicate;
    }

    @SaveVertexParam(value="then")
    public IntegerVertex getThn() {
        return this.thn;
    }

    @SaveVertexParam(value="else")
    public IntegerVertex getEls() {
        return this.els;
    }

    @Override
    public IntegerTensor calculate() {
        return this.op((BooleanTensor)this.predicate.getValue(), (IntegerTensor)this.thn.getValue(), (IntegerTensor)this.els.getValue());
    }

    private IntegerTensor op(BooleanTensor predicate, IntegerTensor thn, IntegerTensor els) {
        return predicate.integerWhere(thn, els);
    }
}

