/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.intgr;

import io.improbable.keanu.algorithms.Samples;
import io.improbable.keanu.tensor.NumberTensor;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class IntegerVertexSamples
extends Samples<IntegerTensor> {
    public IntegerVertexSamples(List<IntegerTensor> samples) {
        super(samples);
    }

    public DoubleTensor getAverages() {
        if (this.samples.isEmpty()) {
            throw new IllegalStateException("No samples exist for averaging.");
        }
        long[] shape = ((IntegerTensor)this.samples.iterator().next()).getShape();
        return (DoubleTensor)((Object)this.samples.stream().reduce(IntegerTensor.zeros(shape), NumberTensor::plusInPlace).toDouble().divInPlace(Double.valueOf(this.samples.size())));
    }

    public Integer getScalarMode() {
        return this.getModeAtIndex(0L, 0L);
    }

    public Integer getModeAtIndex(long ... index) {
        if (this.samples.isEmpty()) {
            throw new IllegalStateException("Mode for empty samples is undefined");
        }
        Map<Integer, List<Integer>> groupedByValue = this.samples.stream().map(v -> (Integer)v.getValue(index)).collect(Collectors.groupingBy(v -> v));
        Optional<Integer> mode = groupedByValue.entrySet().stream().sorted(Comparator.comparing(v -> -((List)v.getValue()).size())).map(Map.Entry::getKey).findFirst();
        if (mode.isPresent()) {
            return mode.get();
        }
        throw new IllegalStateException("Mode is undefined");
    }

    @Override
    public IntegerTensor asTensor() {
        return IntegerTensor.stack(0, this.samples.toArray(new IntegerTensor[0]));
    }
}

