/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.generic.nonprobabilistic;

import com.google.common.base.Preconditions;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.generic.GenericVertex;
import java.io.PrintStream;

public class PrintVertex<T>
extends GenericVertex<T>
implements NonProbabilistic<T> {
    private static PrintStream printStream = System.out;
    private static final String PARENT = "parent";
    private static final String MESSAGE = "message";
    private static final String PRINT_DATA = "printData";
    private final Vertex<T> parent;
    private final String message;
    private final boolean printData;

    public static void setPrintStream(PrintStream printStream) {
        PrintVertex.printStream = (PrintStream)Preconditions.checkNotNull((Object)printStream);
    }

    @ExportVertexToPythonBindings
    public PrintVertex(@LoadVertexParam(value="parent") Vertex<T> parent, @LoadVertexParam(value="message") String message, @LoadVertexParam(value="printData") boolean printData) {
        super(parent.getShape());
        this.parent = parent;
        this.message = (String)Preconditions.checkNotNull((Object)message);
        this.printData = printData;
        this.setParents(parent);
    }

    public PrintVertex(Vertex<T> parent) {
        this(parent, "Calculated Vertex:\n", true);
    }

    @Override
    public T calculate() {
        return PrintVertex.print(this.parent.getValue(), this.message, this.printData);
    }

    public static <T> T print(T parentValue, String message, boolean printData) {
        String dataOutput = printData ? parentValue.toString() + "\n" : "";
        printStream.print(message + dataOutput);
        return parentValue;
    }

    @SaveVertexParam(value="parent")
    public Vertex<T> getParent() {
        return this.parent;
    }

    @SaveVertexParam(value="message")
    public String getMessage() {
        return this.message;
    }

    @SaveVertexParam(value="printData")
    public boolean getPrintData() {
        return this.printData;
    }
}

