/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.generic.nonprobabilistic;

import io.improbable.keanu.tensor.TensorShape;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.generic.GenericVertex;
import io.improbable.keanu.vertices.intgr.IntegerVertex;

public class MultiplexerVertex<T>
extends GenericVertex<T>
implements NonProbabilistic<T> {
    private static final String SELECTOR_CONTROL_NAME = "selectorControlVertex";
    private static final String SELECT_VERTICES_NAME = "selectVertices";
    private final IntegerVertex selectorControlVertex;
    private final Vertex<T>[] selectVertices;

    public MultiplexerVertex(@LoadVertexParam(value="selectorControlVertex") IntegerVertex selectorControlVertex, Vertex<T> ... select) {
        if (!TensorShape.isScalar(selectorControlVertex.getShape())) {
            throw new IllegalArgumentException("Select control must be scalar integer");
        }
        this.selectVertices = select;
        this.selectorControlVertex = selectorControlVertex;
        this.setParents(select);
        this.addParent(selectorControlVertex);
    }

    private Vertex<T> getSelector() {
        int optionGroupIdx = (Integer)((IntegerTensor)this.selectorControlVertex.getValue()).scalar();
        return this.selectVertices[optionGroupIdx];
    }

    @Override
    public T calculate() {
        Vertex<T> selector = this.getSelector();
        return selector.getValue();
    }

    public static <T> T mux(IntegerTensor select, T ... outputs) {
        return outputs[(Integer)select.scalar()];
    }

    @SaveVertexParam(value="selectorControlVertex")
    public IntegerVertex getSelectorControlVertex() {
        return this.selectorControlVertex;
    }

    @SaveVertexParam(value="selectVertices")
    public Vertex<T>[] getSelectVertices() {
        return this.selectVertices;
    }
}

