/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.generic.nonprobabilistic;

import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.generic.GenericTensor;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.NonSaveableVertex;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.generic.GenericTensorVertex;
import io.improbable.keanu.vertices.generic.nonprobabilistic.CPTCondition;
import java.util.List;
import java.util.Map;

public class CPTVertex<T>
extends GenericTensorVertex<T>
implements NonProbabilistic<GenericTensor<T>>,
NonSaveableVertex {
    private final List<Vertex<? extends Tensor<?, ?>>> inputs;
    private final Map<CPTCondition, ? extends Vertex<GenericTensor<T>>> conditions;
    private final Vertex<GenericTensor<T>> defaultResult;

    public CPTVertex(List<Vertex<? extends Tensor<?, ?>>> inputs, Map<CPTCondition, ? extends Vertex<GenericTensor<T>>> conditions, Vertex<GenericTensor<T>> defaultResult) {
        this.conditions = conditions;
        this.inputs = inputs;
        this.defaultResult = defaultResult;
        this.addParents(inputs);
        this.addParents(conditions.values());
        this.addParent(defaultResult);
    }

    @Override
    public GenericTensor<T> calculate() {
        CPTCondition condition = CPTCondition.from(this.inputs, v -> ((Tensor)v.getValue()).scalar());
        Vertex<GenericTensor<T>> vertex = this.conditions.get(condition);
        return vertex == null ? this.defaultResult.getValue() : vertex.getValue();
    }
}

