/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl.probabilistic;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.distributions.continuous.Uniform;
import io.improbable.keanu.tensor.NumberTensor;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.LoadShape;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.LogProbGraph;
import io.improbable.keanu.vertices.LogProbGraphSupplier;
import io.improbable.keanu.vertices.SamplableWithManyScalars;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.dbl.Differentiable;
import io.improbable.keanu.vertices.dbl.DoublePlaceholderVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.ConstantDoubleVertex;
import io.improbable.keanu.vertices.dbl.probabilistic.ProbabilisticDouble;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class UniformVertex
extends DoubleVertex
implements Differentiable,
ProbabilisticDouble,
SamplableWithManyScalars<DoubleTensor>,
LogProbGraphSupplier {
    private final DoubleVertex xMin;
    private final DoubleVertex xMax;
    private static final String X_MIN_NAME = "xMin";
    private static final String X_MAX_NAME = "xMax";

    public UniformVertex(@LoadShape long[] tensorShape, @LoadVertexParam(value="xMin") DoubleVertex xMin, @LoadVertexParam(value="xMax") DoubleVertex xMax) {
        super(tensorShape);
        TensorShapeValidation.checkTensorsMatchNonLengthOneShapeOrAreLengthOne(tensorShape, xMin.getShape(), xMax.getShape());
        this.xMin = xMin;
        this.xMax = xMax;
        this.setParents(xMin, xMax);
    }

    @ExportVertexToPythonBindings
    public UniformVertex(DoubleVertex xMin, DoubleVertex xMax) {
        this(TensorShapeValidation.checkHasOneNonLengthOneShapeOrAllLengthOne(xMin.getShape(), xMax.getShape()), xMin, xMax);
    }

    public UniformVertex(DoubleVertex xMin, double xMax) {
        this(xMin, (DoubleVertex)new ConstantDoubleVertex(xMax));
    }

    public UniformVertex(double xMin, DoubleVertex xMax) {
        this((DoubleVertex)new ConstantDoubleVertex(xMin), xMax);
    }

    public UniformVertex(double xMin, double xMax) {
        this((DoubleVertex)new ConstantDoubleVertex(xMin), (DoubleVertex)new ConstantDoubleVertex(xMax));
    }

    public UniformVertex(long[] tensorShape, DoubleVertex xMin, double xMax) {
        this(tensorShape, xMin, (DoubleVertex)new ConstantDoubleVertex(xMax));
    }

    public UniformVertex(long[] tensorShape, double xMin, DoubleVertex xMax) {
        this(tensorShape, (DoubleVertex)new ConstantDoubleVertex(xMin), xMax);
    }

    public UniformVertex(long[] tensorShape, double xMin, double xMax) {
        this(tensorShape, (DoubleVertex)new ConstantDoubleVertex(xMin), (DoubleVertex)new ConstantDoubleVertex(xMax));
    }

    @SaveVertexParam(value="xMin")
    public DoubleVertex getXMin() {
        return this.xMin;
    }

    @SaveVertexParam(value="xMax")
    public DoubleVertex getXMax() {
        return this.xMax;
    }

    @Override
    public double logProb(DoubleTensor value) {
        return (Double)Uniform.withParameters((DoubleTensor)this.xMin.getValue(), (DoubleTensor)this.xMax.getValue()).logProb(value).sum();
    }

    @Override
    public LogProbGraph logProbGraph() {
        DoublePlaceholderVertex xPlaceholder = new DoublePlaceholderVertex(this.getShape());
        DoublePlaceholderVertex xMinPlaceholder = new DoublePlaceholderVertex(this.xMin.getShape());
        DoublePlaceholderVertex xMaxPlaceholder = new DoublePlaceholderVertex(this.xMax.getShape());
        return LogProbGraph.builder().input(this, xPlaceholder).input(this.xMin, xMinPlaceholder).input(this.xMax, xMaxPlaceholder).logProbOutput(Uniform.logProbOutput(xPlaceholder, xMinPlaceholder, xMaxPlaceholder)).build();
    }

    @Override
    public Map<Vertex, DoubleTensor> dLogProb(DoubleTensor value, Set<? extends Vertex> withRespectTo) {
        if (withRespectTo.contains(this)) {
            DoubleTensor dLogPdx = DoubleTensor.zeros(this.xMax.getShape());
            dLogPdx = (DoubleTensor)dLogPdx.setWithMaskInPlace(value.greaterThanMask((NumberTensor)this.xMax.getValue()), Double.NEGATIVE_INFINITY);
            dLogPdx = (DoubleTensor)dLogPdx.setWithMaskInPlace(value.lessThanOrEqualToMask((NumberTensor)this.xMin.getValue()), Double.POSITIVE_INFINITY);
            return Collections.singletonMap(this, dLogPdx);
        }
        return Collections.emptyMap();
    }

    @Override
    public DoubleTensor sampleWithShape(long[] shape, KeanuRandom random) {
        return (DoubleTensor)Uniform.withParameters((DoubleTensor)this.xMin.getValue(), (DoubleTensor)this.xMax.getValue()).sample(shape, random);
    }
}

