/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl.probabilistic;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.distributions.continuous.Triangular;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.LoadShape;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.LogProbGraph;
import io.improbable.keanu.vertices.LogProbGraphSupplier;
import io.improbable.keanu.vertices.SamplableWithManyScalars;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.dbl.Differentiable;
import io.improbable.keanu.vertices.dbl.DoublePlaceholderVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.ConstantDoubleVertex;
import io.improbable.keanu.vertices.dbl.probabilistic.ProbabilisticDouble;
import java.util.Map;
import java.util.Set;

public class TriangularVertex
extends DoubleVertex
implements Differentiable,
ProbabilisticDouble,
SamplableWithManyScalars<DoubleTensor>,
LogProbGraphSupplier {
    private final DoubleVertex xMin;
    private final DoubleVertex xMax;
    private final DoubleVertex c;
    private static final String X_MIN_NAME = "xMin";
    private static final String X_MAX_NAME = "xMax";
    private static final String C_NAME = "c";

    public TriangularVertex(@LoadShape long[] tensorShape, @LoadVertexParam(value="xMin") DoubleVertex xMin, @LoadVertexParam(value="xMax") DoubleVertex xMax, @LoadVertexParam(value="c") DoubleVertex c) {
        super(tensorShape);
        TensorShapeValidation.checkTensorsMatchNonLengthOneShapeOrAreLengthOne(tensorShape, xMin.getShape(), xMax.getShape(), c.getShape());
        this.xMin = xMin;
        this.xMax = xMax;
        this.c = c;
        this.setParents(xMin, xMax, c);
    }

    public TriangularVertex(long[] tensorShape, DoubleVertex xMin, DoubleVertex xMax, double c) {
        this(tensorShape, xMin, xMax, (DoubleVertex)new ConstantDoubleVertex(c));
    }

    public TriangularVertex(long[] tensorShape, DoubleVertex xMin, double xMax, DoubleVertex c) {
        this(tensorShape, xMin, (DoubleVertex)new ConstantDoubleVertex(xMax), c);
    }

    public TriangularVertex(long[] tensorShape, DoubleVertex xMin, double xMax, double c) {
        this(tensorShape, xMin, (DoubleVertex)new ConstantDoubleVertex(xMax), (DoubleVertex)new ConstantDoubleVertex(c));
    }

    public TriangularVertex(long[] tensorShape, double xMin, DoubleVertex xMax, DoubleVertex c) {
        this(tensorShape, (DoubleVertex)new ConstantDoubleVertex(xMin), xMax, c);
    }

    public TriangularVertex(long[] tensorShape, double xMin, double xMax, DoubleVertex c) {
        this(tensorShape, (DoubleVertex)new ConstantDoubleVertex(xMin), (DoubleVertex)new ConstantDoubleVertex(xMax), c);
    }

    public TriangularVertex(long[] tensorShape, double xMin, double xMax, double c) {
        this(tensorShape, (DoubleVertex)new ConstantDoubleVertex(xMin), (DoubleVertex)new ConstantDoubleVertex(xMax), (DoubleVertex)new ConstantDoubleVertex(c));
    }

    @ExportVertexToPythonBindings
    public TriangularVertex(DoubleVertex xMin, DoubleVertex xMax, DoubleVertex c) {
        this(TensorShapeValidation.checkHasOneNonLengthOneShapeOrAllLengthOne(xMin.getShape(), xMax.getShape(), c.getShape()), xMin, xMax, c);
    }

    public TriangularVertex(DoubleVertex xMin, DoubleVertex xMax, double c) {
        this(xMin, xMax, (DoubleVertex)new ConstantDoubleVertex(c));
    }

    public TriangularVertex(DoubleVertex xMin, double xMax, DoubleVertex c) {
        this(xMin, (DoubleVertex)new ConstantDoubleVertex(xMax), c);
    }

    public TriangularVertex(DoubleVertex xMin, double xMax, double c) {
        this(xMin, (DoubleVertex)new ConstantDoubleVertex(xMax), (DoubleVertex)new ConstantDoubleVertex(c));
    }

    public TriangularVertex(double xMin, DoubleVertex xMax, DoubleVertex c) {
        this((DoubleVertex)new ConstantDoubleVertex(xMin), xMax, c);
    }

    public TriangularVertex(double xMin, double xMax, DoubleVertex c) {
        this((DoubleVertex)new ConstantDoubleVertex(xMin), (DoubleVertex)new ConstantDoubleVertex(xMax), c);
    }

    public TriangularVertex(double xMin, double xMax, double c) {
        this((DoubleVertex)new ConstantDoubleVertex(xMin), (DoubleVertex)new ConstantDoubleVertex(xMax), (DoubleVertex)new ConstantDoubleVertex(c));
    }

    @SaveVertexParam(value="xMin")
    public DoubleVertex getXMin() {
        return this.xMin;
    }

    @SaveVertexParam(value="xMax")
    public DoubleVertex getXMax() {
        return this.xMax;
    }

    @SaveVertexParam(value="c")
    public DoubleVertex getC() {
        return this.c;
    }

    @Override
    public double logProb(DoubleTensor value) {
        DoubleTensor xMinValues = (DoubleTensor)this.xMin.getValue();
        DoubleTensor xMaxValues = (DoubleTensor)this.xMax.getValue();
        DoubleTensor cValues = (DoubleTensor)this.c.getValue();
        DoubleTensor logPdfs = Triangular.withParameters(xMinValues, xMaxValues, cValues).logProb(value);
        return (Double)logPdfs.sum();
    }

    @Override
    public LogProbGraph logProbGraph() {
        DoublePlaceholderVertex xPlaceholder = new DoublePlaceholderVertex(this.getShape());
        DoublePlaceholderVertex xMinPlaceholder = new DoublePlaceholderVertex(this.xMin.getShape());
        DoublePlaceholderVertex xMaxPlaceholder = new DoublePlaceholderVertex(this.xMax.getShape());
        DoublePlaceholderVertex cPlaceholder = new DoublePlaceholderVertex(this.c.getShape());
        return LogProbGraph.builder().input(this, xPlaceholder).input(this.xMin, xMinPlaceholder).input(this.xMax, xMaxPlaceholder).input(this.c, cPlaceholder).logProbOutput(Triangular.logProbOutput(xPlaceholder, xMinPlaceholder, xMaxPlaceholder, cPlaceholder)).build();
    }

    @Override
    public Map<Vertex, DoubleTensor> dLogProb(DoubleTensor value, Set<? extends Vertex> withRespectTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DoubleTensor sampleWithShape(long[] shape, KeanuRandom random) {
        return (DoubleTensor)Triangular.withParameters((DoubleTensor)this.xMin.getValue(), (DoubleTensor)this.xMax.getValue(), (DoubleTensor)this.c.getValue()).sample(shape, random);
    }
}

