/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl.probabilistic;

import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.Probabilistic;
import io.improbable.keanu.vertices.Vertex;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public interface ProbabilisticDouble
extends Probabilistic<DoubleTensor> {
    default public double logPdf(double value) {
        return this.logPdf(DoubleTensor.scalar(value));
    }

    default public double logPdf(double[] values) {
        return this.logPdf(DoubleTensor.create(values));
    }

    default public double logPdf(DoubleTensor value) {
        return this.logProb(value);
    }

    default public Map<Vertex, DoubleTensor> dLogPdf(double value, Set<Vertex> withRespectTo) {
        return this.dLogPdf(DoubleTensor.scalar(value), withRespectTo);
    }

    default public Map<Vertex, DoubleTensor> dLogPdf(double value, Vertex ... withRespectTo) {
        return this.dLogPdf(DoubleTensor.scalar(value), new HashSet<Vertex>(Arrays.asList(withRespectTo)));
    }

    default public Map<Vertex, DoubleTensor> dLogPdf(double[] values, Set<Vertex> withRespectTo) {
        return this.dLogPdf(DoubleTensor.create(values), withRespectTo);
    }

    default public Map<Vertex, DoubleTensor> dLogPdf(double[] values, Vertex ... withRespectTo) {
        return this.dLogPdf(DoubleTensor.create(values), new HashSet<Vertex>(Arrays.asList(withRespectTo)));
    }

    default public Map<Vertex, DoubleTensor> dLogPdf(DoubleTensor value, Set<Vertex> withRespectTo) {
        return this.dLogProb(value, withRespectTo);
    }

    default public Map<Vertex, DoubleTensor> dLogPdf(DoubleTensor value, Vertex ... withRespectTo) {
        return this.dLogPdf(value, new HashSet<Vertex>(Arrays.asList(withRespectTo)));
    }
}

