/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl.probabilistic;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.distributions.continuous.Pareto;
import io.improbable.keanu.distributions.hyperparam.Diffs;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.LoadShape;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.LogProbGraph;
import io.improbable.keanu.vertices.LogProbGraphSupplier;
import io.improbable.keanu.vertices.SamplableWithManyScalars;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.dbl.Differentiable;
import io.improbable.keanu.vertices.dbl.DoublePlaceholderVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.ConstantDoubleVertex;
import io.improbable.keanu.vertices.dbl.probabilistic.ProbabilisticDouble;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ParetoVertex
extends DoubleVertex
implements Differentiable,
ProbabilisticDouble,
SamplableWithManyScalars<DoubleTensor>,
LogProbGraphSupplier {
    private final DoubleVertex scale;
    private final DoubleVertex location;
    private static final String SCALE_NAME = "scale";
    private static final String LOCATION_NAME = "location";

    public ParetoVertex(@LoadShape long[] tensorShape, @LoadVertexParam(value="location") DoubleVertex location, @LoadVertexParam(value="scale") DoubleVertex scale) {
        super(tensorShape);
        TensorShapeValidation.checkTensorsMatchNonLengthOneShapeOrAreLengthOne(tensorShape, location.getShape(), scale.getShape());
        this.scale = scale;
        this.location = location;
        this.setParents(location, scale);
    }

    @ExportVertexToPythonBindings
    public ParetoVertex(DoubleVertex location, DoubleVertex scale) {
        this(TensorShapeValidation.checkHasOneNonLengthOneShapeOrAllLengthOne(location.getShape(), scale.getShape()), location, scale);
    }

    public ParetoVertex(double location, DoubleVertex scale) {
        this((DoubleVertex)new ConstantDoubleVertex(location), scale);
    }

    public ParetoVertex(DoubleVertex location, double scale) {
        this(location, (DoubleVertex)new ConstantDoubleVertex(scale));
    }

    public ParetoVertex(double location, double scale) {
        this((DoubleVertex)new ConstantDoubleVertex(location), (DoubleVertex)new ConstantDoubleVertex(scale));
    }

    public ParetoVertex(long[] tensorShape, double location, DoubleVertex scale) {
        this(tensorShape, (DoubleVertex)new ConstantDoubleVertex(location), scale);
    }

    public ParetoVertex(long[] tensorShape, DoubleVertex location, double scale) {
        this(tensorShape, location, (DoubleVertex)new ConstantDoubleVertex(scale));
    }

    public ParetoVertex(long[] tensorShape, double location, double scale) {
        this(tensorShape, (DoubleVertex)new ConstantDoubleVertex(location), (DoubleVertex)new ConstantDoubleVertex(scale));
    }

    @SaveVertexParam(value="scale")
    public DoubleVertex getScale() {
        return this.scale;
    }

    @SaveVertexParam(value="location")
    public DoubleVertex getLocation() {
        return this.location;
    }

    @Override
    public double logProb(DoubleTensor value) {
        DoubleTensor locValues = (DoubleTensor)this.location.getValue();
        DoubleTensor scaleValues = (DoubleTensor)this.scale.getValue();
        DoubleTensor logPdfs = Pareto.withParameters(locValues, scaleValues).logProb(value);
        return (Double)logPdfs.sum();
    }

    @Override
    public LogProbGraph logProbGraph() {
        DoublePlaceholderVertex xPlaceholder = new DoublePlaceholderVertex(this.getShape());
        DoublePlaceholderVertex locationPlaceholder = new DoublePlaceholderVertex(this.location.getShape());
        DoublePlaceholderVertex scalePlaceholder = new DoublePlaceholderVertex(this.scale.getShape());
        return LogProbGraph.builder().input(this, xPlaceholder).input(this.location, locationPlaceholder).input(this.scale, scalePlaceholder).logProbOutput(Pareto.logProbOutput(xPlaceholder, locationPlaceholder, scalePlaceholder)).build();
    }

    @Override
    public Map<Vertex, DoubleTensor> dLogProb(DoubleTensor value, Set<? extends Vertex> withRespectTo) {
        Diffs dlnP = Pareto.withParameters((DoubleTensor)this.location.getValue(), (DoubleTensor)this.scale.getValue()).dLogProb(value);
        HashMap<Vertex, DoubleTensor> dLogProbWrtParameters = new HashMap<Vertex, DoubleTensor>();
        if (withRespectTo.contains(this.location)) {
            dLogProbWrtParameters.put(this.location, dlnP.get(Diffs.L).getValue());
        }
        if (withRespectTo.contains(this.scale)) {
            dLogProbWrtParameters.put(this.scale, dlnP.get(Diffs.S).getValue());
        }
        if (withRespectTo.contains(this)) {
            dLogProbWrtParameters.put(this, dlnP.get(Diffs.X).getValue());
        }
        return dLogProbWrtParameters;
    }

    @Override
    public DoubleTensor sampleWithShape(long[] shape, KeanuRandom random) {
        return (DoubleTensor)Pareto.withParameters((DoubleTensor)this.location.getValue(), (DoubleTensor)this.scale.getValue()).sample(shape, random);
    }
}

