/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl.probabilistic;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.distributions.continuous.Logistic;
import io.improbable.keanu.distributions.hyperparam.Diffs;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.LoadShape;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.LogProbGraph;
import io.improbable.keanu.vertices.LogProbGraphSupplier;
import io.improbable.keanu.vertices.SamplableWithManyScalars;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.dbl.Differentiable;
import io.improbable.keanu.vertices.dbl.DoublePlaceholderVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.ConstantDoubleVertex;
import io.improbable.keanu.vertices.dbl.probabilistic.ProbabilisticDouble;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LogisticVertex
extends DoubleVertex
implements Differentiable,
ProbabilisticDouble,
SamplableWithManyScalars<DoubleTensor>,
LogProbGraphSupplier {
    private final DoubleVertex mu;
    private final DoubleVertex s;
    private static final String MU_NAME = "mu";
    private static final String S_NAME = "s";

    public LogisticVertex(@LoadShape long[] tensorShape, @LoadVertexParam(value="mu") DoubleVertex mu, @LoadVertexParam(value="s") DoubleVertex s) {
        super(tensorShape);
        TensorShapeValidation.checkTensorsMatchNonLengthOneShapeOrAreLengthOne(tensorShape, mu.getShape(), s.getShape());
        this.mu = mu;
        this.s = s;
        this.setParents(mu, s);
    }

    @ExportVertexToPythonBindings
    public LogisticVertex(DoubleVertex mu, DoubleVertex s) {
        this(TensorShapeValidation.checkHasOneNonLengthOneShapeOrAllLengthOne(mu.getShape(), s.getShape()), mu, s);
    }

    public LogisticVertex(DoubleVertex mu, double s) {
        this(mu, (DoubleVertex)new ConstantDoubleVertex(s));
    }

    public LogisticVertex(double mu, DoubleVertex s) {
        this((DoubleVertex)new ConstantDoubleVertex(mu), s);
    }

    public LogisticVertex(double mu, double s) {
        this((DoubleVertex)new ConstantDoubleVertex(mu), (DoubleVertex)new ConstantDoubleVertex(s));
    }

    @SaveVertexParam(value="mu")
    public DoubleVertex getMu() {
        return this.mu;
    }

    @SaveVertexParam(value="s")
    public DoubleVertex getS() {
        return this.s;
    }

    @Override
    public double logProb(DoubleTensor value) {
        DoubleTensor muValues = (DoubleTensor)this.mu.getValue();
        DoubleTensor sValues = (DoubleTensor)this.s.getValue();
        DoubleTensor logPdfs = Logistic.withParameters(muValues, sValues).logProb(value);
        return (Double)logPdfs.sum();
    }

    @Override
    public LogProbGraph logProbGraph() {
        DoublePlaceholderVertex xPlaceholder = new DoublePlaceholderVertex(this.getShape());
        DoublePlaceholderVertex muPlaceholder = new DoublePlaceholderVertex(this.mu.getShape());
        DoublePlaceholderVertex sPlaceholder = new DoublePlaceholderVertex(this.s.getShape());
        return LogProbGraph.builder().input(this, xPlaceholder).input(this.mu, muPlaceholder).input(this.s, sPlaceholder).logProbOutput(Logistic.logProbOutput(xPlaceholder, muPlaceholder, sPlaceholder)).build();
    }

    @Override
    public Map<Vertex, DoubleTensor> dLogProb(DoubleTensor value, Set<? extends Vertex> withRespectTo) {
        Diffs dlnP = Logistic.withParameters((DoubleTensor)this.mu.getValue(), (DoubleTensor)this.s.getValue()).dLogProb(value);
        HashMap<Vertex, DoubleTensor> dLogProbWrtParameters = new HashMap<Vertex, DoubleTensor>();
        if (withRespectTo.contains(this.mu)) {
            dLogProbWrtParameters.put(this.mu, dlnP.get(Diffs.MU).getValue());
        }
        if (withRespectTo.contains(this.s)) {
            dLogProbWrtParameters.put(this.s, dlnP.get(Diffs.S).getValue());
        }
        if (withRespectTo.contains(this)) {
            dLogProbWrtParameters.put(this, dlnP.get(Diffs.X).getValue());
        }
        return dLogProbWrtParameters;
    }

    @Override
    public DoubleTensor sampleWithShape(long[] shape, KeanuRandom random) {
        return (DoubleTensor)Logistic.withParameters((DoubleTensor)this.mu.getValue(), (DoubleTensor)this.s.getValue()).sample(shape, random);
    }
}

