/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl.probabilistic;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.distributions.continuous.Laplace;
import io.improbable.keanu.distributions.hyperparam.Diffs;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.LoadShape;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.LogProbGraph;
import io.improbable.keanu.vertices.LogProbGraphSupplier;
import io.improbable.keanu.vertices.SamplableWithManyScalars;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.dbl.Differentiable;
import io.improbable.keanu.vertices.dbl.DoublePlaceholderVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.ConstantDoubleVertex;
import io.improbable.keanu.vertices.dbl.probabilistic.ProbabilisticDouble;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LaplaceVertex
extends DoubleVertex
implements Differentiable,
ProbabilisticDouble,
SamplableWithManyScalars<DoubleTensor>,
LogProbGraphSupplier {
    private final DoubleVertex mu;
    private final DoubleVertex beta;
    private static final String MU_NAME = "mu";
    private static final String BETA_NAME = "beta";

    public LaplaceVertex(@LoadShape long[] tensorShape, @LoadVertexParam(value="mu") DoubleVertex mu, @LoadVertexParam(value="beta") DoubleVertex beta) {
        super(tensorShape);
        TensorShapeValidation.checkTensorsMatchNonLengthOneShapeOrAreLengthOne(tensorShape, mu.getShape(), beta.getShape());
        this.mu = mu;
        this.beta = beta;
        this.setParents(mu, beta);
    }

    public LaplaceVertex(long[] shape, DoubleVertex mu, double beta) {
        this(shape, mu, (DoubleVertex)new ConstantDoubleVertex(beta));
    }

    public LaplaceVertex(long[] shape, double mu, DoubleVertex beta) {
        this(shape, (DoubleVertex)new ConstantDoubleVertex(mu), beta);
    }

    public LaplaceVertex(long[] shape, double mu, double beta) {
        this(shape, (DoubleVertex)new ConstantDoubleVertex(mu), (DoubleVertex)new ConstantDoubleVertex(beta));
    }

    @ExportVertexToPythonBindings
    public LaplaceVertex(DoubleVertex mu, DoubleVertex beta) {
        this(TensorShapeValidation.checkHasOneNonLengthOneShapeOrAllLengthOne(mu.getShape(), beta.getShape()), mu, beta);
    }

    public LaplaceVertex(DoubleVertex mu, double beta) {
        this(mu, (DoubleVertex)new ConstantDoubleVertex(beta));
    }

    public LaplaceVertex(double mu, DoubleVertex beta) {
        this((DoubleVertex)new ConstantDoubleVertex(mu), beta);
    }

    public LaplaceVertex(double mu, double beta) {
        this((DoubleVertex)new ConstantDoubleVertex(mu), (DoubleVertex)new ConstantDoubleVertex(beta));
    }

    @SaveVertexParam(value="mu")
    public DoubleVertex getMu() {
        return this.mu;
    }

    @SaveVertexParam(value="beta")
    public DoubleVertex getBeta() {
        return this.beta;
    }

    @Override
    public double logProb(DoubleTensor value) {
        DoubleTensor muValues = (DoubleTensor)this.mu.getValue();
        DoubleTensor betaValues = (DoubleTensor)this.beta.getValue();
        DoubleTensor logPdfs = Laplace.withParameters(muValues, betaValues).logProb(value);
        return (Double)logPdfs.sum();
    }

    @Override
    public LogProbGraph logProbGraph() {
        DoublePlaceholderVertex xPlaceholder = new DoublePlaceholderVertex(this.getShape());
        DoublePlaceholderVertex muPlaceholder = new DoublePlaceholderVertex(this.mu.getShape());
        DoublePlaceholderVertex betaPlaceholder = new DoublePlaceholderVertex(this.beta.getShape());
        return LogProbGraph.builder().input(this, xPlaceholder).input(this.mu, muPlaceholder).input(this.beta, betaPlaceholder).logProbOutput(Laplace.logProbOutput(xPlaceholder, muPlaceholder, betaPlaceholder)).build();
    }

    @Override
    public Map<Vertex, DoubleTensor> dLogProb(DoubleTensor value, Set<? extends Vertex> withRespectTo) {
        Diffs dlnP = Laplace.withParameters((DoubleTensor)this.mu.getValue(), (DoubleTensor)this.beta.getValue()).dLogProb(value);
        HashMap<Vertex, DoubleTensor> dLogProbWrtParameters = new HashMap<Vertex, DoubleTensor>();
        if (withRespectTo.contains(this.mu)) {
            dLogProbWrtParameters.put(this.mu, dlnP.get(Diffs.MU).getValue());
        }
        if (withRespectTo.contains(this.beta)) {
            dLogProbWrtParameters.put(this.beta, dlnP.get(Diffs.BETA).getValue());
        }
        if (withRespectTo.contains(this)) {
            dLogProbWrtParameters.put(this, dlnP.get(Diffs.X).getValue());
        }
        return dLogProbWrtParameters;
    }

    @Override
    public DoubleTensor sampleWithShape(long[] shape, KeanuRandom random) {
        return (DoubleTensor)Laplace.withParameters((DoubleTensor)this.mu.getValue(), (DoubleTensor)this.beta.getValue()).sample(shape, random);
    }
}

