/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl.probabilistic;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.distributions.continuous.Cauchy;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.LoadShape;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.LogProbGraph;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.dbl.DoublePlaceholderVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.operators.binary.AdditionVertex;
import io.improbable.keanu.vertices.dbl.probabilistic.CauchyVertex;
import java.util.Map;
import java.util.Set;

public class HalfCauchyVertex
extends CauchyVertex {
    private static final double LOC_ZERO = 0.0;
    private static final double LOG_TWO = Math.log(2.0);

    public HalfCauchyVertex(@LoadShape long[] tensorShape, @LoadVertexParam(value="scale") DoubleVertex scale) {
        super(tensorShape, 0.0, scale);
    }

    public HalfCauchyVertex(long[] tensorShape, double scale) {
        super(tensorShape, 0.0, scale);
    }

    @ExportVertexToPythonBindings
    public HalfCauchyVertex(DoubleVertex scale) {
        super(0.0, scale);
    }

    public HalfCauchyVertex(double scale) {
        super(0.0, scale);
    }

    @Override
    public double logProb(DoubleTensor value) {
        if (value.greaterThanOrEqual(0.0).allTrue()) {
            return super.logProb(value) + LOG_TWO * (double)value.getLength();
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public LogProbGraph logProbGraph() {
        DoublePlaceholderVertex xPlaceholder = new DoublePlaceholderVertex(this.getShape());
        DoublePlaceholderVertex locationPlaceholder = new DoublePlaceholderVertex(this.getLocation().getShape());
        DoublePlaceholderVertex scalePlaceholder = new DoublePlaceholderVertex(this.getScale().getShape());
        DoubleVertex cauchyLogProbOutput = Cauchy.logProbOutput(xPlaceholder, locationPlaceholder, scalePlaceholder);
        AdditionVertex result = cauchyLogProbOutput.plus(LOG_TWO);
        DoubleVertex invalidMask = xPlaceholder.toLessThanMask(0.0);
        DoubleVertex halfCauchyLogProbOutput = result.setWithMask(invalidMask, Double.NEGATIVE_INFINITY);
        locationPlaceholder.setValue(0.0);
        return LogProbGraph.builder().input(this, xPlaceholder).input(this.getLocation(), locationPlaceholder).input(this.getScale(), scalePlaceholder).logProbOutput(halfCauchyLogProbOutput).build();
    }

    @Override
    public Map<Vertex, DoubleTensor> dLogProb(DoubleTensor value, Set<? extends Vertex> withRespectTo) {
        Map<Vertex, DoubleTensor> logProb = super.dLogProb(value, withRespectTo);
        if (value.greaterThanOrEqual(0.0).allTrue()) {
            return logProb;
        }
        for (Map.Entry<Vertex, DoubleTensor> entry : logProb.entrySet()) {
            DoubleTensor v = entry.getValue();
            logProb.put(entry.getKey(), v.setWithMaskInPlace(value.lessThanMask(DoubleTensor.scalar(0.0)), 0.0));
        }
        return logProb;
    }

    @Override
    public DoubleTensor sampleWithShape(long[] shape, KeanuRandom random) {
        return (DoubleTensor)super.sampleWithShape(shape, random).absInPlace();
    }
}

