/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl.probabilistic;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.distributions.continuous.Gamma;
import io.improbable.keanu.distributions.hyperparam.Diffs;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.LoadShape;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.LogProbGraph;
import io.improbable.keanu.vertices.LogProbGraphSupplier;
import io.improbable.keanu.vertices.SamplableWithManyScalars;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.dbl.Differentiable;
import io.improbable.keanu.vertices.dbl.DoublePlaceholderVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.ConstantDoubleVertex;
import io.improbable.keanu.vertices.dbl.probabilistic.ProbabilisticDouble;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GammaVertex
extends DoubleVertex
implements Differentiable,
ProbabilisticDouble,
SamplableWithManyScalars<DoubleTensor>,
LogProbGraphSupplier {
    private final DoubleVertex theta;
    private final DoubleVertex k;
    private static final String THETA_NAME = "theta";
    private static final String K_NAME = "k";

    public GammaVertex(@LoadShape long[] tensorShape, @LoadVertexParam(value="theta") DoubleVertex theta, @LoadVertexParam(value="k") DoubleVertex k) {
        super(tensorShape);
        TensorShapeValidation.checkTensorsMatchNonLengthOneShapeOrAreLengthOne(tensorShape, theta.getShape(), k.getShape());
        this.theta = theta;
        this.k = k;
        this.setParents(theta, k);
    }

    @ExportVertexToPythonBindings
    public GammaVertex(DoubleVertex theta, DoubleVertex k) {
        this(TensorShapeValidation.checkHasOneNonLengthOneShapeOrAllLengthOne(theta.getShape(), k.getShape()), theta, k);
    }

    public GammaVertex(DoubleVertex theta, double k) {
        this(theta, (DoubleVertex)new ConstantDoubleVertex(k));
    }

    public GammaVertex(double theta, DoubleVertex k) {
        this((DoubleVertex)new ConstantDoubleVertex(theta), k);
    }

    public GammaVertex(double theta, double k) {
        this((DoubleVertex)new ConstantDoubleVertex(theta), (DoubleVertex)new ConstantDoubleVertex(k));
    }

    @SaveVertexParam(value="theta")
    public DoubleVertex getTheta() {
        return this.theta;
    }

    @SaveVertexParam(value="k")
    public DoubleVertex getK() {
        return this.k;
    }

    @Override
    public double logProb(DoubleTensor value) {
        DoubleTensor thetaValues = (DoubleTensor)this.theta.getValue();
        DoubleTensor kValues = (DoubleTensor)this.k.getValue();
        DoubleTensor logPdfs = Gamma.withParameters(thetaValues, kValues).logProb(value);
        return (Double)logPdfs.sum();
    }

    @Override
    public LogProbGraph logProbGraph() {
        DoublePlaceholderVertex xPlaceholder = new DoublePlaceholderVertex(this.getShape());
        DoublePlaceholderVertex thetaPlaceholder = new DoublePlaceholderVertex(this.theta.getShape());
        DoublePlaceholderVertex kPlaceholder = new DoublePlaceholderVertex(this.k.getShape());
        return LogProbGraph.builder().input(this, xPlaceholder).input(this.theta, thetaPlaceholder).input(this.k, kPlaceholder).logProbOutput(Gamma.logProbOutput(xPlaceholder, thetaPlaceholder, kPlaceholder)).build();
    }

    @Override
    public Map<Vertex, DoubleTensor> dLogProb(DoubleTensor value, Set<? extends Vertex> withRespectTo) {
        Diffs dlnP = Gamma.withParameters((DoubleTensor)this.theta.getValue(), (DoubleTensor)this.k.getValue()).dLogProb(value);
        HashMap<Vertex, DoubleTensor> dLogProbWrtParameters = new HashMap<Vertex, DoubleTensor>();
        if (withRespectTo.contains(this.theta)) {
            dLogProbWrtParameters.put(this.theta, dlnP.get(Diffs.THETA).getValue());
        }
        if (withRespectTo.contains(this.k)) {
            dLogProbWrtParameters.put(this.k, dlnP.get(Diffs.K).getValue());
        }
        if (withRespectTo.contains(this)) {
            dLogProbWrtParameters.put(this, dlnP.get(Diffs.X).getValue());
        }
        return dLogProbWrtParameters;
    }

    @Override
    public DoubleTensor sampleWithShape(long[] shape, KeanuRandom random) {
        return (DoubleTensor)Gamma.withParameters((DoubleTensor)this.theta.getValue(), (DoubleTensor)this.k.getValue()).sample(shape, random);
    }
}

