/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl.probabilistic;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.distributions.continuous.Exponential;
import io.improbable.keanu.distributions.hyperparam.Diffs;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.LoadShape;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.LogProbGraph;
import io.improbable.keanu.vertices.LogProbGraphSupplier;
import io.improbable.keanu.vertices.SamplableWithManyScalars;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.dbl.Differentiable;
import io.improbable.keanu.vertices.dbl.DoublePlaceholderVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.ConstantDoubleVertex;
import io.improbable.keanu.vertices.dbl.probabilistic.ProbabilisticDouble;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ExponentialVertex
extends DoubleVertex
implements Differentiable,
ProbabilisticDouble,
SamplableWithManyScalars<DoubleTensor>,
LogProbGraphSupplier {
    private final DoubleVertex rate;
    private static final String RATE_NAME = "rate";

    public ExponentialVertex(@LoadShape long[] tensorShape, @LoadVertexParam(value="rate") DoubleVertex rate) {
        super(tensorShape);
        TensorShapeValidation.checkTensorsMatchNonLengthOneShapeOrAreLengthOne(tensorShape, new long[][]{rate.getShape()});
        this.rate = rate;
        this.setParents(rate);
    }

    @ExportVertexToPythonBindings
    public ExponentialVertex(DoubleVertex rate) {
        this(TensorShapeValidation.checkHasOneNonLengthOneShapeOrAllLengthOne(new long[][]{rate.getShape()}), rate);
    }

    public ExponentialVertex(double rate) {
        this(new ConstantDoubleVertex(rate));
    }

    @SaveVertexParam(value="rate")
    public DoubleVertex getRate() {
        return this.rate;
    }

    @Override
    public double logProb(DoubleTensor value) {
        DoubleTensor lambdaValues = (DoubleTensor)this.rate.getValue();
        DoubleTensor logPdfs = Exponential.withParameters(lambdaValues).logProb(value);
        return (Double)logPdfs.sum();
    }

    @Override
    public LogProbGraph logProbGraph() {
        DoublePlaceholderVertex xPlaceholder = new DoublePlaceholderVertex(this.getShape());
        DoublePlaceholderVertex ratePlaceholder = new DoublePlaceholderVertex(this.rate.getShape());
        return LogProbGraph.builder().input(this, xPlaceholder).input(this.rate, ratePlaceholder).logProbOutput(Exponential.logProbOutput(xPlaceholder, ratePlaceholder)).build();
    }

    @Override
    public Map<Vertex, DoubleTensor> dLogProb(DoubleTensor value, Set<? extends Vertex> withRespectTo) {
        Diffs dlnP = Exponential.withParameters((DoubleTensor)this.rate.getValue()).dLogProb(value);
        HashMap<Vertex, DoubleTensor> dLogProbWrtParameters = new HashMap<Vertex, DoubleTensor>();
        if (withRespectTo.contains(this.rate)) {
            dLogProbWrtParameters.put(this.rate, dlnP.get(Diffs.LAMBDA).getValue());
        }
        if (withRespectTo.contains(this)) {
            dLogProbWrtParameters.put(this, dlnP.get(Diffs.X).getValue());
        }
        return dLogProbWrtParameters;
    }

    @Override
    public DoubleTensor sampleWithShape(long[] shape, KeanuRandom random) {
        return (DoubleTensor)Exponential.withParameters((DoubleTensor)this.rate.getValue()).sample(shape, random);
    }
}

