/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl.probabilistic;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.distributions.continuous.Dirichlet;
import io.improbable.keanu.distributions.hyperparam.Diffs;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.LoadShape;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.LogProbGraph;
import io.improbable.keanu.vertices.LogProbGraphSupplier;
import io.improbable.keanu.vertices.SamplableWithManyScalars;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.dbl.Differentiable;
import io.improbable.keanu.vertices.dbl.DoublePlaceholderVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.ConstantDoubleVertex;
import io.improbable.keanu.vertices.dbl.probabilistic.ProbabilisticDouble;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DirichletVertex
extends DoubleVertex
implements Differentiable,
ProbabilisticDouble,
SamplableWithManyScalars<DoubleTensor>,
LogProbGraphSupplier {
    private final DoubleVertex concentration;
    private static final String CONCENTRATION_NAME = "concentration";

    public DirichletVertex(@LoadShape long[] tensorShape, @LoadVertexParam(value="concentration") DoubleVertex concentration) {
        super(tensorShape);
        this.concentration = concentration;
        if (((DoubleTensor)concentration.getValue()).getLength() < 2L) {
            throw new IllegalArgumentException("Dirichlet must be comprised of more than one concentration parameter");
        }
        this.setParents(concentration);
    }

    @ExportVertexToPythonBindings
    public DirichletVertex(DoubleVertex concentration) {
        this(concentration.getShape(), concentration);
    }

    public DirichletVertex(long[] tensorShape, double concentration) {
        this(tensorShape, new ConstantDoubleVertex(DoubleTensor.create(concentration, tensorShape)));
    }

    public DirichletVertex(double ... concentration) {
        this(new ConstantDoubleVertex(concentration));
    }

    @SaveVertexParam(value="concentration")
    public DoubleVertex getConcentration() {
        return this.concentration;
    }

    @Override
    public double logProb(DoubleTensor value) {
        DoubleTensor concentrationValues = (DoubleTensor)this.concentration.getValue();
        DoubleTensor logPdfs = Dirichlet.withParameters(concentrationValues).logProb(value);
        return (Double)logPdfs.sum();
    }

    @Override
    public LogProbGraph logProbGraph() {
        DoublePlaceholderVertex xPlaceholder = new DoublePlaceholderVertex(this.getShape());
        DoublePlaceholderVertex concentrationPlaceholder = new DoublePlaceholderVertex(this.concentration.getShape());
        return LogProbGraph.builder().input(this, xPlaceholder).input(this.concentration, concentrationPlaceholder).logProbOutput(Dirichlet.logProbOutput(xPlaceholder, concentrationPlaceholder)).build();
    }

    @Override
    public Map<Vertex, DoubleTensor> dLogProb(DoubleTensor value, Set<? extends Vertex> withRespectTo) {
        Diffs dlnP = Dirichlet.withParameters((DoubleTensor)this.concentration.getValue()).dLogProb(value);
        HashMap<Vertex, DoubleTensor> dLogProbWrtParameters = new HashMap<Vertex, DoubleTensor>();
        if (withRespectTo.contains(this.concentration)) {
            dLogProbWrtParameters.put(this.concentration, dlnP.get(Diffs.C).getValue());
        }
        if (withRespectTo.contains(this)) {
            dLogProbWrtParameters.put(this, dlnP.get(Diffs.X).getValue());
        }
        return dLogProbWrtParameters;
    }

    @Override
    public DoubleTensor sampleWithShape(long[] shape, KeanuRandom random) {
        return (DoubleTensor)Dirichlet.withParameters((DoubleTensor)this.concentration.getValue()).sample(shape, random);
    }
}

