/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl.nonprobabilistic.operators.binary;

import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.VertexBinaryOp;
import io.improbable.keanu.vertices.dbl.DoubleVertex;

public abstract class DoubleBinaryOpVertex
extends DoubleVertex
implements NonProbabilistic<DoubleTensor>,
VertexBinaryOp<DoubleVertex, DoubleVertex> {
    protected final DoubleVertex left;
    protected final DoubleVertex right;
    protected static final String LEFT_NAME = "left";
    protected static final String RIGHT_NAME = "right";

    public DoubleBinaryOpVertex(DoubleVertex left, DoubleVertex right) {
        this(TensorShapeValidation.checkHasOneNonLengthOneShapeOrAllLengthOne(left.getShape(), right.getShape()), left, right);
    }

    public DoubleBinaryOpVertex(long[] shape, DoubleVertex left, DoubleVertex right) {
        super(shape);
        this.left = left;
        this.right = right;
        this.setParents(left, right);
    }

    @Override
    public DoubleTensor calculate() {
        return this.op((DoubleTensor)this.left.getValue(), (DoubleTensor)this.right.getValue());
    }

    @Override
    @SaveVertexParam(value="left")
    public DoubleVertex getLeft() {
        return this.left;
    }

    @Override
    @SaveVertexParam(value="right")
    public DoubleVertex getRight() {
        return this.right;
    }

    protected abstract DoubleTensor op(DoubleTensor var1, DoubleTensor var2);
}

