/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl.nonprobabilistic.operators.binary;

import io.improbable.keanu.annotation.DisplayInformationForOutput;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.dbl.Differentiable;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.diff.AutoDiffBroadcast;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.diff.PartialDerivative;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.operators.binary.DoubleBinaryOpVertex;
import java.util.HashMap;
import java.util.Map;

@DisplayInformationForOutput(displayName="/")
public class DivisionVertex
extends DoubleBinaryOpVertex
implements Differentiable {
    @ExportVertexToPythonBindings
    public DivisionVertex(@LoadVertexParam(value="left") DoubleVertex left, @LoadVertexParam(value="right") DoubleVertex right) {
        super(TensorShapeValidation.checkIsBroadcastable(left.getShape(), right.getShape()), left, right);
    }

    @Override
    protected DoubleTensor op(DoubleTensor l, DoubleTensor r) {
        return l.div(r);
    }

    @Override
    public PartialDerivative forwardModeAutoDifferentiation(Map<Vertex, PartialDerivative> derivativeOfParentsWithRespectToInput) {
        PartialDerivative dLeftWrtInput = derivativeOfParentsWithRespectToInput.getOrDefault(this.left, PartialDerivative.EMPTY);
        PartialDerivative dRightWrtInput = derivativeOfParentsWithRespectToInput.getOrDefault(this.right, PartialDerivative.EMPTY);
        PartialDerivative fromLeft = AutoDiffBroadcast.correctForBroadcastPartialForward(dLeftWrtInput, this.left.getShape(), this.getShape());
        PartialDerivative fromRight = AutoDiffBroadcast.correctForBroadcastPartialForward(dRightWrtInput, this.right.getShape(), this.getShape());
        PartialDerivative partialsFromLeft = fromLeft.multiplyAlongOfDimensions((DoubleTensor)this.right.getValue(), this.getRank());
        PartialDerivative partialsFromRight = fromRight.multiplyAlongOfDimensions((DoubleTensor)this.left.getValue(), this.getRank());
        return partialsFromLeft.subtract(partialsFromRight).divideByAlongOfDimensions(((DoubleTensor)this.right.getValue()).pow(2.0), this.getRank());
    }

    @Override
    public Map<Vertex, PartialDerivative> reverseModeAutoDifferentiation(PartialDerivative derivativeOfOutputWithRespectToSelf) {
        HashMap<Vertex, PartialDerivative> partials = new HashMap<Vertex, PartialDerivative>();
        DoubleTensor leftValue = (DoubleTensor)this.left.getValue();
        DoubleTensor rightValue = (DoubleTensor)this.right.getValue();
        DoubleTensor dOutWrtLeft = (DoubleTensor)rightValue.reciprocal();
        DoubleTensor dOutWrtRight = (DoubleTensor)leftValue.div(rightValue.pow(2.0)).unaryMinusInPlace();
        PartialDerivative dOutputsWrtLeft = derivativeOfOutputWithRespectToSelf.multiplyAlongWrtDimensions(dOutWrtLeft);
        PartialDerivative dOutputsWrtRight = derivativeOfOutputWithRespectToSelf.multiplyAlongWrtDimensions(dOutWrtRight);
        PartialDerivative toLeft = AutoDiffBroadcast.correctForBroadcastPartialReverse(dOutputsWrtLeft, this.getShape(), this.left.getShape());
        PartialDerivative toRight = AutoDiffBroadcast.correctForBroadcastPartialReverse(dOutputsWrtRight, this.getShape(), this.right.getShape());
        partials.put(this.left, toLeft);
        partials.put(this.right, toRight);
        return partials;
    }
}

