/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl.nonprobabilistic;

import com.google.common.collect.Iterables;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.LoadShape;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.ProxyVertex;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.VertexLabel;
import io.improbable.keanu.vertices.dbl.Differentiable;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.diff.PartialDerivative;
import java.util.Collections;
import java.util.Map;

public class DoubleProxyVertex
extends DoubleVertex
implements Differentiable,
ProxyVertex<DoubleVertex>,
NonProbabilistic<DoubleTensor> {
    private static final String LABEL_PARAM_NAME = "label";
    private static final String PARENT_NAME = "parent";

    public DoubleProxyVertex(VertexLabel label) {
        this(Tensor.SCALAR_SHAPE, label);
    }

    @ExportVertexToPythonBindings
    public DoubleProxyVertex(long[] shape, VertexLabel label) {
        super(shape);
        this.setLabel(label);
    }

    public DoubleProxyVertex(@LoadShape long[] shape, @LoadVertexParam(value="label") String labelString, @LoadVertexParam(value="parent", isNullable=true) DoubleVertex parent) {
        super(shape);
        VertexLabel vertexLabel = VertexLabel.parseLabel(labelString);
        this.setLabel(vertexLabel);
        if (parent != null) {
            this.setParent(parent);
        }
    }

    @Override
    public <V extends Vertex<DoubleTensor>> V setLabel(VertexLabel label) {
        if (this.getLabel() != null && !this.getLabel().getUnqualifiedName().equals(label.getUnqualifiedName())) {
            throw new RuntimeException("You should not change the label on a Proxy Vertex");
        }
        return super.setLabel(label);
    }

    public DoubleProxyVertex(long[] shape, String label) {
        this(shape, new VertexLabel(label));
    }

    @Override
    public DoubleTensor calculate() {
        return (DoubleTensor)this.getParent().getValue();
    }

    @Override
    public void setParent(DoubleVertex newParent) {
        TensorShapeValidation.checkTensorsMatchNonLengthOneShapeOrAreLengthOne(this.getShape(), new long[][]{newParent.getShape()});
        this.setParents(newParent);
    }

    @SaveVertexParam(value="parent", isNullable=true)
    public DoubleVertex getParent() {
        return (DoubleVertex)Iterables.getOnlyElement(this.getParents(), null);
    }

    @Override
    public boolean hasParent() {
        return !this.getParents().isEmpty();
    }

    @Override
    public PartialDerivative forwardModeAutoDifferentiation(Map<Vertex, PartialDerivative> derivativeOfParentsWithRespectToInput) {
        return derivativeOfParentsWithRespectToInput.get(this.getParent());
    }

    @Override
    public Map<Vertex, PartialDerivative> reverseModeAutoDifferentiation(PartialDerivative derivativeOfOutputWithRespectToSelf) {
        return Collections.singletonMap(this.getParent(), derivativeOfOutputWithRespectToSelf);
    }

    @SaveVertexParam(value="label")
    public String getLabelParameter() {
        return this.getLabel().toString();
    }
}

