/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.dbl;

import io.improbable.keanu.algorithms.Samples;
import io.improbable.keanu.algorithms.statistics.Autocorrelation;
import io.improbable.keanu.tensor.NumberTensor;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import java.util.List;

public class DoubleVertexSamples
extends Samples<DoubleTensor> {
    private final long[] sampleShape;

    public DoubleVertexSamples(List<DoubleTensor> samples) {
        super(samples);
        this.sampleShape = samples.iterator().next().getShape();
    }

    public DoubleTensor getAverages() {
        return (DoubleTensor)((Object)this.samples.stream().reduce(DoubleTensor.zeros(this.sampleShape), NumberTensor::plusInPlace).divInPlace(Double.valueOf(this.samples.size())));
    }

    public DoubleTensor getVariances() {
        DoubleTensor sumOfSquares = this.samples.stream().reduce(DoubleTensor.zeros(this.sampleShape), (l, r) -> l.plusInPlace(r.pow(2.0)));
        return (DoubleTensor)((Object)((DoubleTensor)((Object)((DoubleTensor)((Object)sumOfSquares.divInPlace(Double.valueOf(this.samples.size())))).minusInPlace(this.getAverages().pow(2.0)).timesInPlace(Double.valueOf(this.samples.size())))).divInPlace((double)this.samples.size() - 1.0));
    }

    public DoubleTensor getAutocorrelation(long ... index) {
        TensorShapeValidation.checkIndexIsValid(this.sampleShape, index);
        long[] indexToGet = this.getCorrectIndexIfScalar(index);
        double[] sampleValuesAtIndex = this.samples.stream().mapToDouble(x -> (Double)x.getValue(indexToGet)).toArray();
        double[] autocorr = Autocorrelation.calculate(sampleValuesAtIndex);
        return DoubleTensor.create(autocorr);
    }

    private long[] getCorrectIndexIfScalar(long ... index) {
        long[] lArray;
        if (this.sampleShape.length == 0) {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = 0L;
        } else {
            lArray = index;
        }
        return lArray;
    }

    @Override
    public DoubleTensor asTensor() {
        return DoubleTensor.stack(0, (DoubleTensor[])this.samples.stream().toArray(DoubleTensor[]::new));
    }
}

