/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.bool.nonprobabilistic.operators.unary;

import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.operators.unary.BooleanUnaryOpVertex;

public class BooleanTakeVertex
extends BooleanUnaryOpVertex<BooleanTensor> {
    private static final String INDEX_NAME = "index";
    private final long[] index;

    @ExportVertexToPythonBindings
    public BooleanTakeVertex(@LoadVertexParam(value="inputVertex") Vertex<BooleanTensor> inputVertex, long ... index) {
        super(Tensor.SCALAR_SHAPE, inputVertex);
        this.index = index;
        TensorShapeValidation.checkIndexIsValid(inputVertex.getShape(), index);
    }

    @Override
    protected BooleanTensor op(BooleanTensor value) {
        return BooleanTensor.scalar((Boolean)value.getValue(this.index));
    }

    @SaveVertexParam(value="index")
    public long[] getIndex() {
        return this.index;
    }
}

