/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.bool.nonprobabilistic.operators.unary;

import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.TensorShape;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.operators.unary.BooleanUnaryOpVertex;

public class BooleanSliceVertex
extends BooleanUnaryOpVertex<BooleanTensor> {
    private static final String DIMENSION_NAME = "dimension";
    private static final String INDEX_NAME = "index";
    private final int dimension;
    private final long index;

    @ExportVertexToPythonBindings
    public BooleanSliceVertex(@LoadVertexParam(value="inputVertex") Vertex<BooleanTensor> inputVertex, @LoadVertexParam(value="dimension") int dimension, @LoadVertexParam(value="index") long index) {
        super(TensorShape.removeDimension(dimension, inputVertex.getShape()), inputVertex);
        this.dimension = dimension;
        this.index = index;
    }

    @Override
    protected BooleanTensor op(BooleanTensor value) {
        return (BooleanTensor)value.slice(this.dimension, this.index);
    }

    @SaveVertexParam(value="dimension")
    public int getDimension() {
        return this.dimension;
    }

    @SaveVertexParam(value="index")
    public long getIndex() {
        return this.index;
    }
}

