/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.bool.nonprobabilistic.operators.multiple;

import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.bool.BooleanVertex;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Function;

public class BooleanConcatenationVertex
extends BooleanVertex
implements NonProbabilistic<BooleanTensor> {
    private static final String DIMENSION_NAME = "dimension";
    private static final String OPERANDS_NAME = "operands";
    private final int dimension;
    private final BooleanVertex[] operands;

    public BooleanConcatenationVertex(int dimension, BooleanVertex ... operands) {
        super(TensorShapeValidation.checkShapesCanBeConcatenated(dimension, BooleanConcatenationVertex.extractFromInputs(long[].class, Vertex::getShape, operands)));
        this.dimension = dimension;
        this.operands = operands;
        this.setParents(operands);
    }

    @ExportVertexToPythonBindings
    public BooleanConcatenationVertex(@LoadVertexParam(value="dimension") int dimension, @LoadVertexParam(value="operands") Vertex[] input) {
        this(dimension, BooleanConcatenationVertex.convertVertexArrayToBooleanVertex(input));
    }

    private static BooleanVertex[] convertVertexArrayToBooleanVertex(Vertex[] input) {
        return (BooleanVertex[])Arrays.stream(input).toArray(BooleanVertex[]::new);
    }

    @Override
    public BooleanTensor calculate() {
        return this.op(BooleanConcatenationVertex.extractFromInputs(BooleanTensor.class, Vertex::getValue, this.operands));
    }

    protected BooleanTensor op(BooleanTensor ... inputs) {
        return BooleanTensor.concat(this.dimension, inputs);
    }

    private static <T> T[] extractFromInputs(Class<T> clazz, Function<Vertex<BooleanTensor>, T> func, BooleanVertex[] input) {
        Object[] extract = (Object[])Array.newInstance(clazz, input.length);
        for (int i = 0; i < input.length; ++i) {
            extract[i] = func.apply(input[i]);
        }
        return extract;
    }

    @SaveVertexParam(value="dimension")
    public int getDimension() {
        return this.dimension;
    }

    @SaveVertexParam(value="operands")
    public BooleanVertex[] getOperands() {
        return this.operands;
    }
}

