/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.bool.nonprobabilistic.operators.binary;

import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.VertexBinaryOp;
import io.improbable.keanu.vertices.bool.BooleanVertex;

public abstract class BooleanBinaryOpVertex<A extends Tensor, B extends Tensor>
extends BooleanVertex
implements NonProbabilistic<BooleanTensor>,
VertexBinaryOp<Vertex<A>, Vertex<B>> {
    protected final Vertex<A> left;
    protected final Vertex<B> right;
    protected static final String A_NAME = "left";
    protected static final String B_NAME = "right";

    public BooleanBinaryOpVertex(Vertex<A> left, Vertex<B> right) {
        this(TensorShapeValidation.checkHasOneNonLengthOneShapeOrAllLengthOne(left.getShape(), right.getShape()), left, right);
    }

    public BooleanBinaryOpVertex(long[] shape, Vertex<A> left, Vertex<B> right) {
        super(shape);
        this.left = left;
        this.right = right;
        this.setParents(left, right);
    }

    @Override
    @SaveVertexParam(value="left")
    public Vertex<A> getLeft() {
        return this.left;
    }

    @Override
    @SaveVertexParam(value="right")
    public Vertex<B> getRight() {
        return this.right;
    }

    @Override
    public boolean contradictsObservation() {
        return this.isObserved() && !this.op((Tensor)this.left.getValue(), (Tensor)this.right.getValue()).elementwiseEquals((Tensor)this.getValue()).allTrue();
    }

    @Override
    public BooleanTensor calculate() {
        return this.op((Tensor)this.left.getValue(), (Tensor)this.right.getValue());
    }

    protected abstract BooleanTensor op(A var1, B var2);
}

