/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.bool.nonprobabilistic.operators;

import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.NumberTensor;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.bool.BooleanVertex;

public class NumericalEqualsVertex
extends BooleanVertex
implements NonProbabilistic<BooleanTensor> {
    protected Vertex<? extends NumberTensor> a;
    protected Vertex<? extends NumberTensor> b;
    private Vertex<? extends NumberTensor> epsilon;
    private static final String A_NAME = "a";
    private static final String B_NAME = "b";
    private static final String EPSILON_NAME = "epsilon";

    @ExportVertexToPythonBindings
    public NumericalEqualsVertex(@LoadVertexParam(value="a") Vertex<? extends NumberTensor> a, @LoadVertexParam(value="b") Vertex<? extends NumberTensor> b, @LoadVertexParam(value="epsilon") Vertex<? extends NumberTensor> epsilon) {
        super(a.getShape());
        this.a = a;
        this.b = b;
        this.epsilon = epsilon;
        this.setParents(a, b, epsilon);
    }

    @Override
    public BooleanTensor calculate() {
        return this.op(this.a.getValue(), this.b.getValue(), this.epsilon.getValue());
    }

    private BooleanTensor op(NumberTensor a, NumberTensor b, NumberTensor epsilon) {
        DoubleTensor absoluteDifference = (DoubleTensor)a.toDouble().minus(b.toDouble()).absInPlace();
        return absoluteDifference.lessThanOrEqual(epsilon.toDouble());
    }

    @SaveVertexParam(value="a")
    public Vertex<? extends NumberTensor> getA() {
        return this.a;
    }

    @SaveVertexParam(value="b")
    public Vertex<? extends NumberTensor> getB() {
        return this.b;
    }

    @SaveVertexParam(value="epsilon")
    public Vertex<? extends NumberTensor> getEpsilon() {
        return this.epsilon;
    }
}

