/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.bool.nonprobabilistic;

import com.google.common.collect.Iterables;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.vertices.LoadShape;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.ProxyVertex;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.VertexLabel;
import io.improbable.keanu.vertices.bool.BooleanVertex;

public class BooleanProxyVertex
extends BooleanVertex
implements ProxyVertex<BooleanVertex>,
NonProbabilistic<BooleanTensor> {
    private static final String LABEL_NAME = "label";
    private static final String PARENT_NAME = "parent";

    public BooleanProxyVertex(VertexLabel label) {
        this(Tensor.SCALAR_SHAPE, label);
    }

    @ExportVertexToPythonBindings
    public BooleanProxyVertex(long[] shape, VertexLabel label) {
        super(shape);
        this.setLabel(label);
    }

    public BooleanProxyVertex(@LoadShape long[] shape, @LoadVertexParam(value="label") String labelString, @LoadVertexParam(value="parent", isNullable=true) BooleanVertex parent) {
        super(shape);
        VertexLabel vertexLabel = VertexLabel.parseLabel(labelString);
        this.setLabel(vertexLabel);
        if (parent != null) {
            this.setParent(parent);
        }
    }

    @Override
    public <V extends Vertex<BooleanTensor>> V setLabel(VertexLabel label) {
        if (this.getLabel() != null && !this.getLabel().getUnqualifiedName().equals(label.getUnqualifiedName())) {
            throw new RuntimeException("You should not change the label on a Proxy Vertex");
        }
        return super.setLabel(label);
    }

    public BooleanProxyVertex(long[] shape, String label) {
        this(shape, new VertexLabel(label));
    }

    @Override
    public BooleanTensor calculate() {
        return (BooleanTensor)this.getParent().getValue();
    }

    @Override
    public void setParent(BooleanVertex newParent) {
        TensorShapeValidation.checkTensorsMatchNonLengthOneShapeOrAreLengthOne(this.getShape(), new long[][]{newParent.getShape()});
        this.setParents(newParent);
    }

    @SaveVertexParam(value="parent", isNullable=true)
    public BooleanVertex getParent() {
        return (BooleanVertex)Iterables.getOnlyElement(this.getParents(), null);
    }

    @Override
    public boolean hasParent() {
        return !this.getParents().isEmpty();
    }

    @SaveVertexParam(value="label")
    public String getLabelParameter() {
        return this.getLabel().toString();
    }
}

