/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.bool.nonprobabilistic;

import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.bool.BooleanVertex;

public class BooleanIfVertex
extends BooleanVertex
implements NonProbabilistic<BooleanTensor> {
    private final BooleanVertex predicate;
    private final BooleanVertex thn;
    private final BooleanVertex els;
    private static final String PRED_NAME = "predicate";
    private static final String THN_NAME = "then";
    private static final String ELS_NAME = "else";

    @ExportVertexToPythonBindings
    public BooleanIfVertex(@LoadVertexParam(value="predicate") BooleanVertex predicate, @LoadVertexParam(value="then") BooleanVertex thn, @LoadVertexParam(value="else") BooleanVertex els) {
        super(TensorShapeValidation.checkTernaryConditionShapeIsValid(predicate.getShape(), thn.getShape(), els.getShape()));
        this.predicate = predicate;
        this.thn = thn;
        this.els = els;
        this.setParents(predicate, thn, els);
    }

    protected BooleanTensor op(BooleanTensor predicate, BooleanTensor thn, BooleanTensor els) {
        return predicate.booleanWhere(thn, els);
    }

    @Override
    public BooleanTensor calculate() {
        return this.op((BooleanTensor)this.predicate.getValue(), (BooleanTensor)this.thn.getValue(), (BooleanTensor)this.els.getValue());
    }

    @SaveVertexParam(value="predicate")
    public BooleanVertex getPredicate() {
        return this.predicate;
    }

    @SaveVertexParam(value="then")
    public BooleanVertex getThn() {
        return this.thn;
    }

    @SaveVertexParam(value="else")
    public BooleanVertex getEls() {
        return this.els;
    }
}

