/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class VertexLabel {
    private static final char NAMESPACE_SEPARATOR = '.';
    private final List<String> namespace;
    private final String name;

    public VertexLabel(String name) {
        this.namespace = Collections.emptyList();
        this.name = name;
    }

    public VertexLabel(String outer, String ... inner) {
        this.namespace = ImmutableList.builder().add((Object)outer).add((Object[])Arrays.copyOf(inner, inner.length - 1)).build();
        this.name = inner[inner.length - 1];
    }

    public VertexLabel(List<String> namespace, String name) {
        this.namespace = ImmutableList.copyOf(namespace);
        this.name = name;
    }

    public boolean isInNamespace(String ... namespace) {
        if (namespace.length > this.namespace.size()) {
            return false;
        }
        for (int i = 0; i < namespace.length; ++i) {
            if (this.namespace.get(i).equals(namespace[i])) continue;
            return false;
        }
        return true;
    }

    public VertexLabel withExtraNamespace(String topLevelNamespace) {
        ImmutableList newNamespace = ImmutableList.builder().add((Object)topLevelNamespace).addAll(this.namespace).build();
        return new VertexLabel((List<String>)newNamespace, this.name);
    }

    public VertexLabel withoutOuterNamespace() {
        List<String> reducedNamespace = this.namespace.subList(1, this.namespace.size());
        return new VertexLabel(reducedNamespace, this.name);
    }

    public Optional<String> getOuterNamespace() {
        return this.namespace.stream().findFirst();
    }

    public String getUnqualifiedName() {
        return this.name;
    }

    public String getQualifiedName() {
        ImmutableList names = ImmutableList.builder().addAll(this.namespace).add((Object)this.name).build();
        return Joiner.on((char)'.').join((Iterable)names);
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VertexLabel that = (VertexLabel)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.name);
    }

    public static VertexLabel parseLabel(String label) {
        List<String> namespaces = Arrays.asList(label.split("\\."));
        if (namespaces.size() == 0) {
            return new VertexLabel(label);
        }
        if (namespaces.size() == 1) {
            return new VertexLabel(namespaces.get(0));
        }
        return new VertexLabel(namespaces.subList(0, namespaces.size() - 1), namespaces.get(namespaces.size() - 1));
    }
}

