/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices;

import com.google.common.primitives.Ints;
import io.improbable.keanu.algorithms.VariableReference;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class VertexId
implements Comparable<VertexId>,
VariableReference {
    private static final AtomicLong ID_GENERATOR = new AtomicLong(0L);
    private static final int TOP_LEVEL_ARRAY_SIZE = 1;
    private long[] idValues = new long[1];

    public VertexId() {
        this.idValues[0] = ID_GENERATOR.getAndIncrement();
    }

    public void addPrefix(VertexId prefix) {
        long[] newIdValues = new long[this.idValues.length + prefix.idValues.length];
        System.arraycopy(prefix.idValues, 0, newIdValues, 0, prefix.idValues.length);
        System.arraycopy(this.idValues, 0, newIdValues, prefix.idValues.length, this.idValues.length);
        this.idValues = newIdValues;
    }

    public void resetID() {
        this.idValues = new long[1];
        this.idValues[0] = ID_GENERATOR.getAndIncrement();
    }

    public VertexId(long id) {
        this.idValues[0] = id;
    }

    @Override
    public int compareTo(VertexId that) {
        long comparisonValue = 0L;
        int minDepth = Math.min(this.idValues.length, that.idValues.length);
        for (int i = 0; i < minDepth && comparisonValue == 0L; ++i) {
            comparisonValue = this.idValues[i] - that.idValues[i];
        }
        if (comparisonValue == 0L) {
            comparisonValue = (long)this.idValues.length - (long)that.idValues.length;
        }
        return Ints.saturatedCast((long)comparisonValue);
    }

    public boolean prefixMatches(VertexId prefix) {
        if (prefix.idValues.length > this.idValues.length) {
            return false;
        }
        for (int i = 0; i < prefix.idValues.length; ++i) {
            if (this.idValues[i] == prefix.idValues[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Arrays.toString(this.idValues);
    }

    public int getIndentation() {
        return this.idValues.length;
    }

    public long[] getValue() {
        return Arrays.copyOf(this.idValues, this.idValues.length);
    }

    @Override
    public String toStringReference() {
        return Arrays.stream(this.getValue()).boxed().map(Objects::toString).collect(Collectors.joining("_"));
    }

    public static void resetIdGenerator() {
        ID_GENERATOR.set(0L);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VertexId)) {
            return false;
        }
        VertexId other = (VertexId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.idValues, other.idValues);
    }

    protected boolean canEqual(Object other) {
        return other instanceof VertexId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.idValues);
        return result;
    }
}

