/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices;

import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.Probabilistic;
import io.improbable.keanu.vertices.Vertex;
import java.util.Collection;

public class ProbabilityCalculator {
    private ProbabilityCalculator() {
    }

    public static double calculateLogProbFor(Collection<? extends Vertex> vertices) {
        double sum = 0.0;
        for (Vertex vertex : vertices) {
            if (vertex instanceof Probabilistic) {
                double logProbAtValue = ((Probabilistic)((Object)vertex)).logProbAtValue();
                if (ProbabilityCalculator.isImpossibleLogProb(logProbAtValue)) {
                    return Double.NEGATIVE_INFINITY;
                }
                sum += logProbAtValue;
                continue;
            }
            if (vertex instanceof NonProbabilistic) {
                if (!((NonProbabilistic)((Object)vertex)).contradictsObservation()) continue;
                return Double.NEGATIVE_INFINITY;
            }
            throw new IllegalArgumentException("Found a vertex that is neither Probabilistic nor Non-Probabilistic");
        }
        return sum;
    }

    public static boolean isImpossibleLogProb(double logProb) {
        return logProb == Double.NEGATIVE_INFINITY || Double.isNaN(logProb);
    }
}

