/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices;

import com.google.common.collect.ImmutableList;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.Observable;
import io.improbable.keanu.vertices.Samplable;
import io.improbable.keanu.vertices.Vertex;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface Probabilistic<T>
extends Observable<T>,
Samplable<T> {
    public double logProb(T var1);

    public Map<Vertex, DoubleTensor> dLogProb(T var1, Set<? extends Vertex> var2);

    default public Map<Vertex, DoubleTensor> dLogProb(T atValue, Vertex ... withRespectTo) {
        return this.dLogProb(atValue, new HashSet<Vertex>(Arrays.asList(withRespectTo)));
    }

    public T getValue();

    default public double logProbAtValue() {
        return this.logProb(this.getValue());
    }

    default public Map<Vertex, DoubleTensor> dLogProbAtValue(Set<? extends Vertex> withRespectTo) {
        return this.dLogProb(this.getValue(), withRespectTo);
    }

    default public Map<Vertex, DoubleTensor> dLogProbAtValue(Vertex ... withRespectTo) {
        return this.dLogProb(this.getValue(), withRespectTo);
    }

    public static <V extends Vertex> List<V> keepOnlyProbabilisticVertices(Iterable<? extends Vertex> vertices) {
        ImmutableList.Builder probabilisticVertices = ImmutableList.builder();
        for (Vertex vertex : vertices) {
            if (!(vertex instanceof Probabilistic)) continue;
            probabilisticVertices.add((Object)vertex);
        }
        return probabilisticVertices.build();
    }
}

