/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices;

import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class LogProbGraph {
    private final Map<Vertex<?>, Vertex<?>> inputs;
    private final DoubleVertex logProbOutput;

    public <T> Vertex<T> getPlaceholder(Vertex<T> input) {
        return this.inputs.get(input);
    }

    LogProbGraph(Map<Vertex<?>, Vertex<?>> inputs, DoubleVertex logProbOutput) {
        this.inputs = inputs;
        this.logProbOutput = logProbOutput;
    }

    public static LogProbGraphBuilder builder() {
        return new LogProbGraphBuilder();
    }

    public Map<Vertex<?>, Vertex<?>> getInputs() {
        return this.inputs;
    }

    public DoubleVertex getLogProbOutput() {
        return this.logProbOutput;
    }

    public static class LogProbGraphBuilder {
        private ArrayList<Vertex<?>> inputs$key;
        private ArrayList<Vertex<?>> inputs$value;
        private DoubleVertex logProbOutput;

        LogProbGraphBuilder() {
        }

        public LogProbGraphBuilder input(Vertex<?> inputKey, Vertex<?> inputValue) {
            if (this.inputs$key == null) {
                this.inputs$key = new ArrayList();
                this.inputs$value = new ArrayList();
            }
            this.inputs$key.add(inputKey);
            this.inputs$value.add(inputValue);
            return this;
        }

        public LogProbGraphBuilder inputs(Map<? extends Vertex<?>, ? extends Vertex<?>> inputs) {
            if (this.inputs$key == null) {
                this.inputs$key = new ArrayList();
                this.inputs$value = new ArrayList();
            }
            for (Map.Entry<Vertex<?>, Vertex<?>> $lombokEntry : inputs.entrySet()) {
                this.inputs$key.add($lombokEntry.getKey());
                this.inputs$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public LogProbGraphBuilder clearInputs() {
            if (this.inputs$key != null) {
                this.inputs$key.clear();
                this.inputs$value.clear();
            }
            return this;
        }

        public LogProbGraphBuilder logProbOutput(DoubleVertex logProbOutput) {
            this.logProbOutput = logProbOutput;
            return this;
        }

        public LogProbGraph build() {
            Map<Vertex<?>, Vertex<?>> inputs;
            switch (this.inputs$key == null ? 0 : this.inputs$key.size()) {
                case 0: {
                    inputs = Collections.emptyMap();
                    break;
                }
                case 1: {
                    inputs = Collections.singletonMap(this.inputs$key.get(0), this.inputs$value.get(0));
                    break;
                }
                default: {
                    inputs = new LinkedHashMap(this.inputs$key.size() < 0x40000000 ? 1 + this.inputs$key.size() + (this.inputs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.inputs$key.size(); ++$i) {
                        inputs.put(this.inputs$key.get($i), this.inputs$value.get($i));
                    }
                    inputs = Collections.unmodifiableMap(inputs);
                }
            }
            return new LogProbGraph(inputs, this.logProbOutput);
        }

        public String toString() {
            return "LogProbGraph.LogProbGraphBuilder(inputs$key=" + this.inputs$key + ", inputs$value=" + this.inputs$value + ", logProbOutput=" + this.logProbOutput + ")";
        }
    }

    public static interface PlaceholderVertex {
    }
}

