/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.status;

import io.improbable.keanu.util.status.KeanuAnimationComponent;
import io.improbable.keanu.util.status.StatusBarComponent;
import io.improbable.keanu.util.status.TextComponent;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class StatusBar {
    private static final AtomicBoolean ENABLED = new AtomicBoolean(true);
    private static final long FRAME_PERIOD_MS = 500L;
    private int previouslyPrintedUpdateLength = 0;
    private final TextComponent textComponent = new TextComponent();
    private List<StatusBarComponent> components = Collections.synchronizedList(new ArrayList());
    private static PrintStream defaultPrintStream = System.out;
    private final PrintStream printStream;
    private final ScheduledExecutorService scheduler;
    private final List<Runnable> onFinish = new ArrayList<Runnable>();

    public static void setDefaultPrintStream(PrintStream printStream) {
        defaultPrintStream = printStream;
    }

    public static void disable() {
        ENABLED.set(false);
    }

    public static void enable() {
        ENABLED.set(true);
    }

    private static ScheduledExecutorService getDefaultScheduledExecutorService() {
        return Executors.newScheduledThreadPool(1, r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        });
    }

    public StatusBar(PrintStream printStream, ScheduledExecutorService scheduler) {
        this.printStream = printStream;
        this.scheduler = scheduler;
        String disableStatusBar = System.getProperty("io.improbable.keanu.util.status.StatusBar.disableStatusBar");
        if (disableStatusBar != null && disableStatusBar.equals("true")) {
            StatusBar.disable();
        }
        this.addDefaultComponents();
        this.startUpdateThread();
    }

    private void addDefaultComponents() {
        this.addComponent(new KeanuAnimationComponent());
        this.addComponent(this.textComponent);
    }

    public StatusBar(PrintStream printStream) {
        this(printStream, StatusBar.getDefaultScheduledExecutorService());
    }

    public StatusBar(ScheduledExecutorService scheduler) {
        this(defaultPrintStream, scheduler);
    }

    public StatusBar() {
        this(defaultPrintStream, StatusBar.getDefaultScheduledExecutorService());
    }

    private void startUpdateThread() {
        this.scheduler.scheduleAtFixedRate(this::printUpdate, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    private void printUpdate() {
        if (!this.shouldUpdate()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatComponents());
        this.appendSpacesToClearPreviousContent(sb);
        this.printStream.print(sb.toString());
    }

    private boolean shouldUpdate() {
        return ENABLED.get();
    }

    private String formatComponents() {
        StringBuilder sb = new StringBuilder();
        for (StatusBarComponent component : this.components) {
            String render = component.render();
            if (render == "") continue;
            sb.append(component.render()).append(" ");
        }
        return sb.toString();
    }

    private void appendSpacesToClearPreviousContent(StringBuilder sb) {
        int originalStringLength;
        for (int i = originalStringLength = sb.length(); i < this.previouslyPrintedUpdateLength; ++i) {
            sb.append(" ");
        }
        this.previouslyPrintedUpdateLength = originalStringLength;
    }

    public void finish() {
        this.scheduler.shutdown();
        this.printUpdate();
        this.printFinish();
        this.components.clear();
        this.onFinish.forEach(Runnable::run);
    }

    private void printFinish() {
        if (this.shouldUpdate()) {
            this.printStream.print("\n");
        }
    }

    public void addFinishHandler(Runnable finishHandler) {
        this.onFinish.add(finishHandler);
    }

    public void setMessage(String message) {
        this.textComponent.setText(message);
    }

    public void addComponent(StatusBarComponent component) {
        this.components.add(component);
    }

    public void removeComponent(StatusBarComponent component) {
        this.components.remove(component);
    }
}

