/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.status;

import io.improbable.keanu.util.status.AverageTimeComponent;
import io.improbable.keanu.util.status.TimeComponent;
import java.time.Duration;

public class RemainingTimeComponent
extends TimeComponent {
    private final AverageTimeComponent averageTime = new AverageTimeComponent();
    private final long totalSteps;

    public RemainingTimeComponent(long totalSteps) {
        this.totalSteps = totalSteps;
    }

    @Override
    public String render() {
        StringBuilder renderedString = new StringBuilder(this.averageTime.render());
        long remainingSteps = this.totalSteps - this.averageTime.getCurrentStep().get();
        Duration timeRemaining = this.averageTime.getAverageStepTime().multipliedBy(remainingSteps);
        renderedString.append(", Time remaining: ");
        renderedString.append(this.formatDuration(timeRemaining));
        return renderedString.toString();
    }

    public void step() {
        this.averageTime.step();
    }
}

