/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.status;

import io.improbable.keanu.util.status.ElapsedTimeComponent;
import io.improbable.keanu.util.status.TimeComponent;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;

public class AverageTimeComponent
extends TimeComponent {
    private final ElapsedTimeComponent elapsedTime = new ElapsedTimeComponent();
    private static final long NANOS_IN_SECOND = 1000000000L;
    private AtomicLong currentStep = new AtomicLong(0L);
    private Duration averageStepTime;

    @Override
    public String render() {
        StringBuilder renderedString = new StringBuilder(this.elapsedTime.render());
        long currentStepNow = this.currentStep.get();
        if (currentStepNow != 0L) {
            this.averageStepTime = Duration.between(this.elapsedTime.getStartTime(), Instant.now()).dividedBy(currentStepNow);
            long averageStepTimeNanos = this.averageStepTime.toNanos();
            if (averageStepTimeNanos != 0L) {
                double stepsSecond = 1.0E9 / (double)this.averageStepTime.toNanos();
                renderedString.append(", Steps per second: ");
                renderedString.append(String.format("%.3f", stepsSecond));
            }
        }
        return renderedString.toString();
    }

    public void step() {
        this.currentStep.getAndIncrement();
    }

    public AtomicLong getCurrentStep() {
        return this.currentStep;
    }

    public Duration getAverageStepTime() {
        return this.averageStepTime;
    }
}

