/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.io;

import io.improbable.keanu.annotation.DisplayInformationForOutput;
import io.improbable.keanu.vertices.ConstantVertex;
import io.improbable.keanu.vertices.Vertex;
import java.util.Objects;
import java.util.Optional;

public class VertexDotLabel {
    private final Vertex vertex;
    private String value = "";
    private String annotation = "";
    private String vertexLabel = "";
    private static final String DOT_LABEL_OPENING = "[label=\"";
    private static final String DOT_LABEL_CLOSING = "\"]";

    public VertexDotLabel(Vertex vertex) {
        DisplayInformationForOutput vertexAnnotation;
        this.vertex = vertex;
        if (vertex.getLabel() != null) {
            this.vertexLabel = vertex.getLabel().getUnqualifiedName();
        }
        if ((vertexAnnotation = vertex.getClass().getAnnotation(DisplayInformationForOutput.class)) != null && !vertexAnnotation.displayName().isEmpty()) {
            this.annotation = vertexAnnotation.displayName();
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String inDotFormat() {
        if (!this.value.isEmpty()) {
            StringBuilder dotLabel = new StringBuilder();
            dotLabel.append(this.vertex.getId().hashCode()).append(DOT_LABEL_OPENING).append(this.value);
            this.getDescriptiveInfo().ifPresent(info -> dotLabel.append(" (").append((String)info).append(")"));
            return dotLabel.append(DOT_LABEL_CLOSING).toString();
        }
        return this.vertex.getId().hashCode() + DOT_LABEL_OPENING + this.getDescriptiveInfo().orElse("") + DOT_LABEL_CLOSING;
    }

    private Optional<String> getDescriptiveInfo() {
        if (!this.vertexLabel.isEmpty()) {
            return Optional.of(this.vertexLabel);
        }
        if (this.value.isEmpty() || !(this.vertex instanceof ConstantVertex)) {
            return Optional.of(this.getAnnotationIfPresentElseSimpleName());
        }
        return Optional.empty();
    }

    private String getAnnotationIfPresentElseSimpleName() {
        return this.annotation.isEmpty() ? this.vertex.getClass().getSimpleName() : this.annotation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VertexDotLabel that = (VertexDotLabel)o;
        return Objects.equals(this.vertex, that.vertex);
    }

    public int hashCode() {
        return Objects.hash(this.vertex);
    }
}

