/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.io;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.improbable.keanu.network.BayesianNetwork;
import io.improbable.keanu.network.NetworkSaver;
import io.improbable.keanu.util.io.ProtobufSaver;
import io.improbable.keanu.vertices.ConstantVertex;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.bool.BooleanVertex;
import io.improbable.keanu.vertices.bool.nonprobabilistic.ConstantBooleanVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.ConstantDoubleVertex;
import io.improbable.keanu.vertices.intgr.IntegerVertex;
import io.improbable.keanu.vertices.intgr.nonprobabilistic.ConstantIntegerVertex;
import io.improbable.mir.KeanuSavedBayesNet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;

public class JsonSaver
implements NetworkSaver {
    private final ProtobufSaver protobufSaver;

    public JsonSaver(BayesianNetwork net) {
        this.protobufSaver = new ProtobufSaver(net);
    }

    @Override
    public void save(OutputStream output, boolean saveValues, Map<String, String> metadata) throws IOException {
        KeanuSavedBayesNet.ProtoModel model = this.protobufSaver.getModel(saveValues, metadata);
        OutputStreamWriter outputWriter = new OutputStreamWriter(output);
        String jsonOutput = JsonFormat.printer().print((MessageOrBuilder)model);
        outputWriter.write(jsonOutput);
        ((Writer)outputWriter).close();
    }

    @Override
    public void save(Vertex vertex) {
        this.protobufSaver.save(vertex);
    }

    @Override
    public void save(ConstantVertex vertex) {
        this.protobufSaver.save(vertex);
    }

    @Override
    public void save(ConstantDoubleVertex vertex) {
        this.protobufSaver.save(vertex);
    }

    @Override
    public void save(ConstantIntegerVertex vertex) {
        this.protobufSaver.save(vertex);
    }

    @Override
    public void save(ConstantBooleanVertex vertex) {
        this.protobufSaver.save(vertex);
    }

    @Override
    public void saveValue(Vertex vertex) {
        this.protobufSaver.save(vertex);
    }

    @Override
    public void saveValue(DoubleVertex vertex) {
        this.protobufSaver.save(vertex);
    }

    @Override
    public void saveValue(IntegerVertex vertex) {
        this.protobufSaver.save(vertex);
    }

    @Override
    public void saveValue(BooleanVertex vertex) {
        this.protobufSaver.save(vertex);
    }
}

