/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.io;

import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.improbable.keanu.network.BayesianNetwork;
import io.improbable.keanu.network.NetworkLoader;
import io.improbable.keanu.util.io.ProtobufLoader;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.bool.BooleanVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.intgr.IntegerVertex;
import io.improbable.mir.KeanuSavedBayesNet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class JsonLoader
implements NetworkLoader {
    private final ProtobufLoader protobufLoader = new ProtobufLoader();

    @Override
    public BayesianNetwork loadNetwork(InputStream input) throws IOException {
        String jsonInput = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
        KeanuSavedBayesNet.ProtoModel.Builder modelBuilder = KeanuSavedBayesNet.ProtoModel.newBuilder();
        JsonFormat.parser().merge(jsonInput, (Message.Builder)modelBuilder);
        return this.protobufLoader.loadNetwork(modelBuilder.build());
    }

    @Override
    public void loadValue(DoubleVertex vertex) {
        this.protobufLoader.loadValue(vertex);
    }

    @Override
    public void loadValue(BooleanVertex vertex) {
        this.protobufLoader.loadValue(vertex);
    }

    @Override
    public void loadValue(IntegerVertex vertex) {
        this.protobufLoader.loadValue(vertex);
    }

    @Override
    public void loadValue(Vertex vertex) {
        this.protobufLoader.loadValue(vertex);
    }
}

