/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.io;

import io.improbable.keanu.vertices.Vertex;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class GraphEdge {
    private final Vertex parentVertex;
    private final Vertex childVertex;
    private Set<String> labels = new HashSet<String>();

    public GraphEdge(Vertex v1, Vertex v2) {
        if (v1.getId().compareTo(v2.getId()) < 0) {
            this.parentVertex = v1;
            this.childVertex = v2;
        } else {
            this.parentVertex = v2;
            this.childVertex = v1;
        }
    }

    public void appendToLabel(String dotLabel) {
        this.labels.add(dotLabel);
    }

    public Vertex getParentVertex() {
        return this.parentVertex;
    }

    public Vertex getChildVertex() {
        return this.childVertex;
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphEdge graphEdge = (GraphEdge)o;
        return Objects.equals(this.parentVertex, graphEdge.parentVertex) && Objects.equals(this.childVertex, graphEdge.childVertex);
    }

    public int hashCode() {
        return Objects.hash(this.parentVertex, this.childVertex);
    }
}

