/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.csv.pojo.byrow;

import io.improbable.keanu.util.csv.pojo.PublicFieldMatcher;
import io.improbable.keanu.util.csv.pojo.SetterMatcher;
import io.improbable.keanu.util.csv.pojo.byrow.CsvCellConsumer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RowsAsObjectParser<T> {
    private static final boolean IGNORE_MISSING_FIELDS_DEFAULT = false;
    private final Class<T> base;
    private final Stream<List<String>> inputStream;
    private final List<String> csvTitles;

    public RowsAsObjectParser(Class<T> base, Stream<List<String>> inputStream, List<String> csvTitles) {
        this.base = base;
        this.inputStream = inputStream;
        this.csvTitles = csvTitles;
    }

    public List<T> load(boolean ignoreUnmatchedFields) {
        return this.stream(ignoreUnmatchedFields).collect(Collectors.toList());
    }

    public List<T> load() {
        return this.load(false);
    }

    public Stream<T> stream(boolean ignoreUnmatchedFields) {
        return RowsAsObjectParser.stream(this.base, this.inputStream, this.csvTitles, ignoreUnmatchedFields);
    }

    public Stream<T> stream() {
        return this.stream(false);
    }

    public static <T> Stream<T> stream(Class<T> base, Stream<List<String>> inputStream, List<String> csvTitles) {
        return RowsAsObjectParser.stream(base, inputStream, csvTitles, false);
    }

    public static <T> Stream<T> stream(Class<T> base, Stream<List<String>> csvLinesAsTokens, List<String> csvTitles, boolean ignoreUnmatchedFields) {
        List columnConsumers = RowsAsObjectParser.getCellConsumers(base, csvTitles, ignoreUnmatchedFields);
        return csvLinesAsTokens.map(csvTokens -> RowsAsObjectParser.deserialize(csvTokens, columnConsumers, base));
    }

    private static <T> List<CsvCellConsumer<T>> getCellConsumers(Class<T> base, List<String> fieldTitles, boolean ignoreUnmatchedFields) {
        ArrayList<CsvCellConsumer<T>> columnConsumers = new ArrayList<CsvCellConsumer<T>>();
        CsvCellConsumer defaultConsumer = (target, value) -> {};
        ArrayList<Field> potentialFields = new ArrayList<Field>(Arrays.asList(base.getFields()));
        ArrayList<Method> potentialSetters = new ArrayList<Method>(Arrays.asList(base.getMethods()));
        for (String title : fieldTitles) {
            Optional<CsvCellConsumer<CsvCellConsumer>> consumerForTitle = PublicFieldMatcher.getFieldCellConsumer(title, potentialFields);
            if (!consumerForTitle.isPresent()) {
                consumerForTitle = SetterMatcher.getSetterCellConsumer(title, potentialSetters);
            }
            if (!consumerForTitle.isPresent() && !ignoreUnmatchedFields) {
                throw new IllegalArgumentException("Unable to find field for csv data \"" + title + "\"");
            }
            columnConsumers.add(consumerForTitle.orElse(defaultConsumer));
        }
        return columnConsumers;
    }

    private static <T> T deserialize(List<String> csvTokens, List<CsvCellConsumer<T>> fieldMappers, Class<T> base) {
        try {
            T target = base.newInstance();
            for (int i = 0; i < csvTokens.size(); ++i) {
                BiConsumer fieldConsumer = fieldMappers.get(i);
                if (fieldConsumer == null) continue;
                fieldConsumer.accept(target, csvTokens.get(i));
            }
            return target;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }
}

