/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.csv.pojo.bycolumn;

import io.improbable.keanu.util.csv.pojo.PublicFieldMatcher;
import io.improbable.keanu.util.csv.pojo.SetterMatcher;
import io.improbable.keanu.util.csv.pojo.bycolumn.CsvColumnConsumer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ColumnsVectorizedObjectParser<T> {
    private static final boolean IGNORE_MISSING_FIELDS_DEFAULT = false;
    private final Class<T> base;
    private final Stream<List<String>> inputStream;
    private final List<String> csvTitles;

    public ColumnsVectorizedObjectParser(Class<T> base, Stream<List<String>> inputStream, List<String> csvTitles) {
        this.base = base;
        this.inputStream = inputStream;
        this.csvTitles = csvTitles;
    }

    public T load() {
        return this.load(false);
    }

    public T load(boolean ignoreUnmatchedFields) {
        List<List<String>> csvColumns = this.csvTitles.stream().map(title -> new ArrayList()).collect(Collectors.toList());
        this.inputStream.forEach(line -> {
            for (int i = 0; i < line.size(); ++i) {
                ((List)csvColumns.get(i)).add(line.get(i));
            }
        });
        List<CsvColumnConsumer<T>> columnConsumers = ColumnsVectorizedObjectParser.getColumnConsumers(this.base, this.csvTitles, ignoreUnmatchedFields);
        return ColumnsVectorizedObjectParser.deserialize(csvColumns, columnConsumers, this.base);
    }

    private static <T> List<CsvColumnConsumer<T>> getColumnConsumers(Class<T> base, List<String> fieldTitles, boolean ignoreUnmatchedFields) {
        ArrayList<CsvColumnConsumer<T>> columnConsumers = new ArrayList<CsvColumnConsumer<T>>();
        CsvColumnConsumer defaultConsumer = (target, value) -> {};
        ArrayList<Field> potentialFields = new ArrayList<Field>(Arrays.asList(base.getFields()));
        ArrayList<Method> potentialSetters = new ArrayList<Method>(Arrays.asList(base.getMethods()));
        for (String title : fieldTitles) {
            Optional<CsvColumnConsumer<CsvColumnConsumer>> consumerForTitle = PublicFieldMatcher.getFieldColumnConsumer(title, potentialFields);
            if (!consumerForTitle.isPresent()) {
                consumerForTitle = SetterMatcher.getSetterColumnConsumer(title, potentialSetters);
            }
            if (!consumerForTitle.isPresent() && !ignoreUnmatchedFields) {
                throw new IllegalArgumentException("Unable to find field for csv data \"" + title + "\"");
            }
            columnConsumers.add(consumerForTitle.orElse(defaultConsumer));
        }
        return columnConsumers;
    }

    private static <T> T deserialize(List<List<String>> csvColumns, List<CsvColumnConsumer<T>> fieldMappers, Class<T> base) {
        try {
            T target = base.newInstance();
            for (int i = 0; i < csvColumns.size(); ++i) {
                BiConsumer fieldConsumer = fieldMappers.get(i);
                if (fieldConsumer == null) continue;
                fieldConsumer.accept(target, csvColumns.get(i));
            }
            return target;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }
}

