/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.csv.pojo;

import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

class CsvColumnDeserializer {
    private CsvColumnDeserializer() {
    }

    static Object convertToAppropriateType(List<String> s, Class<?> fieldType) {
        if (fieldType == int[].class) {
            return CsvColumnDeserializer.convertToIntegers(s);
        }
        if (fieldType == Integer[].class) {
            return ArrayUtils.toObject((int[])CsvColumnDeserializer.convertToIntegers(s));
        }
        if (fieldType == IntegerTensor.class) {
            return IntegerTensor.create(CsvColumnDeserializer.convertToIntegers(s));
        }
        if (fieldType == double[].class) {
            return CsvColumnDeserializer.convertToDoubles(s);
        }
        if (fieldType == Double[].class) {
            return ArrayUtils.toObject((double[])CsvColumnDeserializer.convertToDoubles(s));
        }
        if (fieldType == DoubleTensor.class) {
            return DoubleTensor.create(CsvColumnDeserializer.convertToDoubles(s), new long[]{CsvColumnDeserializer.convertToDoubles(s).length, 1L});
        }
        if (fieldType == boolean[].class) {
            return CsvColumnDeserializer.convertToBooleans(s);
        }
        if (fieldType == Boolean[].class) {
            return ArrayUtils.toObject((boolean[])CsvColumnDeserializer.convertToBooleans(s));
        }
        if (fieldType == BooleanTensor.class) {
            return BooleanTensor.create(CsvColumnDeserializer.convertToBooleans(s));
        }
        throw new IllegalArgumentException("Could not convert " + s + " to " + fieldType);
    }

    private static int[] convertToIntegers(List<String> data) {
        return data.stream().mapToDouble(Double::parseDouble).mapToInt(v -> (int)v).toArray();
    }

    private static double[] convertToDoubles(List<String> data) {
        return data.stream().mapToDouble(Double::parseDouble).toArray();
    }

    private static boolean[] convertToBooleans(List<String> data) {
        List<Boolean> bools = data.stream().map(val -> {
            if (StringUtils.isNumeric((CharSequence)val)) {
                return Double.parseDouble(val) == 1.0;
            }
            return val.equalsIgnoreCase("true") || val.equalsIgnoreCase("t");
        }).collect(Collectors.toList());
        return ArrayUtils.toPrimitive((Boolean[])bools.toArray(new Boolean[data.size()]));
    }
}

