/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.csv;

import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Function;

public abstract class Writer {
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    public static final char DEFAULT_ESCAPE_CHAR = '\"';
    public static final String DEFAULT_LINE_END = "\n";
    public static final String DEFAULT_EMPTY_VALUE = "-";
    private char separator = (char)44;
    private char quoteChar = (char)34;
    private char escapeChar = (char)34;
    private String lineEnd = "\n";
    private String emptyValue = "-";
    private String[] header = null;
    private boolean headerEnabled = false;

    public abstract File toFile(File var1) throws IOException;

    public File toFile(String file) throws IOException {
        return this.toFile(new File(file));
    }

    public abstract Writer withDefaultHeader();

    public Writer withSeparator(char s) {
        this.separator = s;
        return this;
    }

    public Writer withEmptyValue(String emptyValue) {
        this.emptyValue = emptyValue;
        return this;
    }

    public Writer withQuoteCharacter(char q) {
        this.quoteChar = q;
        return this;
    }

    public Writer withEscapeCharacter(char e) {
        this.escapeChar = e;
        return this;
    }

    public Writer withLineEnd(String l) {
        this.lineEnd = l;
        return this;
    }

    public Writer withHeaderEnabled(boolean isEnabled) {
        this.headerEnabled = isEnabled;
        return this;
    }

    public char getSeparator() {
        return this.separator;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public String getLineEnd() {
        return this.lineEnd;
    }

    public String getEmptyValue() {
        return this.emptyValue;
    }

    CSVWriter prepareWriter(File file) throws IOException {
        return this.prepareWriter(file, this.separator, this.quoteChar, this.escapeChar, this.lineEnd);
    }

    CSVWriter prepareWriter(File file, char separator, char quoteChar, char escapeChar, String lineEnd) throws IOException {
        CSVWriter writer = new CSVWriter((java.io.Writer)new FileWriter(file), separator, quoteChar, escapeChar, lineEnd);
        if (this.headerEnabled) {
            writer.writeNext(this.header, false);
        }
        return writer;
    }

    String[] createHeader(int size, String headerStyle, Function<Integer, String> func) {
        String[] header = new String[size];
        for (int i = 0; i < size; ++i) {
            header[i] = String.format(headerStyle, func.apply(i));
        }
        return header;
    }

    public Writer withHeader(String ... h) {
        this.header = Arrays.copyOf(h, h.length);
        this.withHeaderEnabled(true);
        return this;
    }
}

