/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.csv;

import io.improbable.keanu.algorithms.NetworkSamples;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.util.csv.ColumnWriter;
import io.improbable.keanu.util.csv.RowWriter;
import io.improbable.keanu.util.csv.SampleWriter;
import io.improbable.keanu.vertices.Vertex;
import java.util.Arrays;
import java.util.List;

public class WriteCsv {
    public static SampleWriter asSamples(NetworkSamples samples, List<? extends Vertex<? extends Tensor>> vertices) {
        return new SampleWriter(samples, vertices);
    }

    public static SampleWriter asSamples(NetworkSamples samples, Vertex<? extends Tensor> ... vertices) {
        return WriteCsv.asSamples(samples, Arrays.asList(vertices));
    }

    public static RowWriter asRows(List<? extends Vertex<? extends Tensor>> vertices) {
        return new RowWriter(vertices);
    }

    public static ColumnWriter asColumns(List<? extends Vertex<? extends Tensor>> vertices) {
        return new ColumnWriter(vertices);
    }

    public static ColumnWriter asColumns(Vertex<? extends Tensor> ... vertices) {
        return WriteCsv.asColumns(Arrays.asList(vertices));
    }

    public static int findLongestTensor(List<? extends Vertex<? extends Tensor>> tensors) {
        int longestTensor = 0;
        for (Vertex<? extends Tensor> vertex : tensors) {
            if (vertex.getValue().getLength() <= (long)longestTensor) continue;
            longestTensor = vertex.getValue().asFlatList().size();
        }
        return longestTensor;
    }
}

