/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.csv;

import com.opencsv.CSVWriter;
import io.improbable.keanu.algorithms.NetworkSamples;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.util.csv.Writer;
import io.improbable.keanu.vertices.Vertex;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SampleWriter
extends Writer {
    private static final String HEADER_STYLE = "{%s}[%d]";
    private NetworkSamples samples;
    private List<? extends Vertex<? extends Tensor>> vertices;

    public SampleWriter(NetworkSamples samples, List<? extends Vertex<? extends Tensor>> vertices) {
        this.samples = samples;
        this.vertices = vertices;
    }

    @Override
    public File toFile(File file) throws IOException {
        try (CSVWriter writer = this.prepareWriter(file);){
            for (int i = 0; i < this.samples.size(); ++i) {
                ArrayList<String> row = new ArrayList<String>();
                for (Vertex<? extends Tensor> vertex : this.vertices) {
                    Tensor sample = (Tensor)this.samples.get(vertex).asList().get(i);
                    List flatList = sample.asFlatList();
                    for (int j = 0; j < flatList.size(); ++j) {
                        row.add(flatList.get(j).toString());
                    }
                }
                String[] rowArray = new String[row.size()];
                writer.writeNext(row.toArray(rowArray), false);
            }
        }
        return file;
    }

    @Override
    public Writer withDefaultHeader() {
        ArrayList<String> header = new ArrayList<String>();
        for (Vertex<? extends Tensor> vertex : this.vertices) {
            int j = 0;
            while ((long)j < vertex.getValue().getLength()) {
                header.add(String.format(HEADER_STYLE, vertex.getId(), j));
                ++j;
            }
        }
        String[] headerToArray = new String[header.size()];
        this.withHeader(header.toArray(headerToArray));
        return this;
    }
}

