/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.csv;

import com.opencsv.CSVWriter;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.util.csv.WriteCsv;
import io.improbable.keanu.util.csv.Writer;
import io.improbable.keanu.vertices.Vertex;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RowWriter
extends Writer {
    private static final String HEADER_STYLE = "[%s]";
    private List<? extends Vertex<? extends Tensor>> vertices;

    public RowWriter(List<? extends Vertex<? extends Tensor>> vertices, String emptyValue) {
        this.vertices = vertices;
        this.withEmptyValue(emptyValue);
    }

    public RowWriter(List<? extends Vertex<? extends Tensor>> vertices) {
        this(vertices, "-");
    }

    @Override
    public File toFile(File file) throws IOException {
        try (CSVWriter writer = this.prepareWriter(file);){
            int maxSize = WriteCsv.findLongestTensor(this.vertices);
            for (Vertex<? extends Tensor> vertex : this.vertices) {
                ArrayList<String> row = new ArrayList<String>();
                List flatList = vertex.getValue().asFlatList();
                for (int i = 0; i < maxSize; ++i) {
                    row.add(i < flatList.size() ? flatList.get(i).toString() : this.getEmptyValue());
                }
                String[] rowArray = new String[row.size()];
                writer.writeNext(row.toArray(rowArray), false);
            }
        }
        return file;
    }

    @Override
    public Writer withDefaultHeader() {
        int sizeOfHeader = WriteCsv.findLongestTensor(this.vertices);
        String[] header = this.createHeader(sizeOfHeader, HEADER_STYLE, i -> Integer.toString(i));
        this.withHeader(header);
        return this;
    }
}

