/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.csv;

import io.improbable.keanu.util.csv.CsvReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ReadCsv {
    private ReadCsv() {
    }

    public static CsvReader fromResources(String fileOnClassPath) {
        return new CsvReader(() -> ReadCsv.getFileFromResources(fileOnClassPath));
    }

    public static CsvReader fromFile(File file) {
        return ReadCsv.fromFile(file.toPath());
    }

    public static CsvReader fromFile(String filePath) {
        return ReadCsv.fromFile(Paths.get(filePath, new String[0]));
    }

    public static CsvReader fromFile(Path filePath) {
        return new CsvReader(() -> {
            try {
                return new BufferedReader(new FileReader(filePath.toFile()));
            }
            catch (FileNotFoundException fnfe) {
                throw new UncheckedIOException(fnfe);
            }
        });
    }

    public static CsvReader fromString(String csvString) {
        return new CsvReader(() -> new StringReader(csvString));
    }

    private static Reader getFileFromResources(String fileOnClassPath) {
        InputStream csvFileStream = ReadCsv.class.getClassLoader().getResourceAsStream(fileOnClassPath);
        if (csvFileStream == null) {
            throw new UncheckedIOException(new FileNotFoundException(fileOnClassPath + " not found on class path!"));
        }
        return new InputStreamReader(csvFileStream);
    }
}

