/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.csv;

import io.improbable.keanu.util.csv.pojo.bycolumn.ColumnsVectorizedObjectParser;
import io.improbable.keanu.util.csv.pojo.byrow.RowsAsObjectParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CsvReader {
    private static final String DEFAULT_DELIMITER = ",";
    private final Supplier<Reader> sourceSupplier;
    private String delimiter;
    private boolean expectHeader;
    private List<String> header;

    public CsvReader(Supplier<Reader> sourceSupplier) {
        this.sourceSupplier = sourceSupplier;
        this.delimiter = DEFAULT_DELIMITER;
        this.expectHeader = true;
        this.header = null;
    }

    public List<List<String>> readLines() {
        try (Stream<List<String>> stream = this.streamLines();){
            List<List<String>> list = stream.collect(Collectors.toList());
            return list;
        }
    }

    public Stream<List<String>> streamLines() {
        BufferedReader bufferedReader = new BufferedReader(this.sourceSupplier.get());
        if (this.expectHeader) {
            try {
                this.header = this.splitLine(bufferedReader.readLine());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return bufferedReader.lines().map(this::splitLine);
    }

    public <T> RowsAsObjectParser<T> asRowsDefinedBy(Class<T> clazz) {
        this.expectHeader(true);
        return new RowsAsObjectParser<T>(clazz, this.streamLines(), this.getHeader());
    }

    public <T> ColumnsVectorizedObjectParser<T> asVectorizedColumnsDefinedBy(Class<T> clazz) {
        this.expectHeader(true);
        return new ColumnsVectorizedObjectParser<T>(clazz, this.streamLines(), this.getHeader());
    }

    public List<String> getHeader() {
        if (!this.expectHeader) {
            return Collections.emptyList();
        }
        if (this.header == null) {
            try (BufferedReader bufferedReader = new BufferedReader(this.sourceSupplier.get());){
                this.header = this.splitLine(bufferedReader.readLine());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.header;
    }

    public CsvReader expectHeader(boolean expectHeader) {
        this.expectHeader = expectHeader;
        return this;
    }

    public CsvReader withDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    private List<String> splitLine(String line) {
        return Arrays.stream(line.split(this.delimiter)).map(String::trim).collect(Collectors.toList());
    }
}

