/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util.csv;

import com.opencsv.CSVWriter;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.util.csv.WriteCsv;
import io.improbable.keanu.util.csv.Writer;
import io.improbable.keanu.vertices.Vertex;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ColumnWriter
extends Writer {
    private static final String HEADER_STYLE = "{%s}";
    private List<? extends Vertex<? extends Tensor>> vertices;

    public ColumnWriter(List<? extends Vertex<? extends Tensor>> vertices, String emptyValue) {
        this.vertices = vertices;
        this.withEmptyValue(emptyValue);
    }

    public ColumnWriter(List<? extends Vertex<? extends Tensor>> vertices) {
        this(vertices, "-");
    }

    @Override
    public File toFile(File file) throws IOException {
        try (CSVWriter writer = this.prepareWriter(file);){
            int maxSize = WriteCsv.findLongestTensor(this.vertices);
            for (int i = 0; i < maxSize; ++i) {
                ArrayList<String> row = new ArrayList<String>();
                for (Vertex<? extends Tensor> vertex : this.vertices) {
                    List flatList = vertex.getValue().asFlatList();
                    row.add(i < flatList.size() ? flatList.get(i).toString() : this.getEmptyValue());
                }
                String[] rowArray = new String[row.size()];
                writer.writeNext(row.toArray(rowArray), false);
            }
        }
        return file;
    }

    @Override
    public Writer withDefaultHeader() {
        int headerSize = this.vertices.size();
        String[] header = this.createHeader(headerSize, HEADER_STYLE, i -> this.vertices.get((int)i).getId().toString());
        this.withHeader(header);
        return this;
    }
}

