/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.util;

import io.improbable.keanu.util.Py4jByteArrayConversionException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;

public final class Py4jByteArrayConverter {
    public static byte[] toByteArray(double[] doubleArray) {
        ByteBuffer doubleBuffer = ByteBuffer.allocate(8 * doubleArray.length);
        doubleBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (double element : doubleArray) {
            doubleBuffer.putDouble(element);
        }
        byte[] byteArray = doubleBuffer.array();
        return byteArray;
    }

    public static byte[] toByteArray(int[] integerArray) {
        ByteBuffer integerBuffer = ByteBuffer.allocate(4 * integerArray.length);
        integerBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int element : integerArray) {
            integerBuffer.putInt(element);
        }
        byte[] byteArray = integerBuffer.array();
        return byteArray;
    }

    public static byte[] toByteArray(boolean[] booleanArray) {
        ByteBuffer booleanBuffer = ByteBuffer.allocate(booleanArray.length);
        booleanBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (boolean element : booleanArray) {
            byte booleanByte = element ? (byte)1 : 0;
            booleanBuffer.put(booleanByte);
        }
        byte[] byteArray = booleanBuffer.array();
        return byteArray;
    }

    public static double[] toDoubleArray(byte[] byteArray) {
        double[] doubles = new double[byteArray.length / 8];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = ByteBuffer.wrap(byteArray, i * 8, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        }
        return doubles;
    }

    public static int[] toIntegerArray(byte[] byteArray) {
        int[] ints = new int[byteArray.length / 4];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = ByteBuffer.wrap(byteArray, i * 4, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
        }
        return ints;
    }

    public static long[] toLongArray(byte[] byteArray) {
        long[] longs = new long[byteArray.length / 8];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = ByteBuffer.wrap(byteArray, i * 8, 8).order(ByteOrder.LITTLE_ENDIAN).getLong();
        }
        return longs;
    }

    public static boolean[] toBooleanArray(byte[] byteArray, int numberOfBooleansInArray) {
        BitSet bits = BitSet.valueOf(byteArray);
        boolean[] bools = new boolean[numberOfBooleansInArray];
        int i = bits.nextSetBit(0);
        while (i != -1) {
            int position = Py4jByteArrayConverter.getBigEndianPosition(i);
            if (position >= numberOfBooleansInArray) {
                throw new Py4jByteArrayConversionException("There are more encoded booleans than the number of booleans specified");
            }
            bools[position] = true;
            i = bits.nextSetBit(i + 1);
        }
        return bools;
    }

    private static int getBigEndianPosition(int index) {
        int byteNumber = index / 8;
        int bitNumber = index % 8;
        return byteNumber * 8 + (7 - bitNumber);
    }

    private Py4jByteArrayConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

